/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.block.BlockMachineMeta;
import de.katzenpapst.amunra.block.SubBlockMachine;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.tile.TileEntityBlockScale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockScale
extends SubBlockMachine {
    private IIcon iconTop = null;
    private IIcon iconBottom = null;
    private IIcon iconFront = null;
    protected final String topTexture;
    protected final String bottomTexture;
    protected final String frontTexture;

    public BlockScale(String name, String sideTexture, String topTexture, String frontTexture, String bottomTexture) {
        super(name, sideTexture);
        this.topTexture = topTexture;
        this.bottomTexture = bottomTexture;
        this.frontTexture = frontTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.iconTop = reg.func_94245_a(this.topTexture);
        this.iconBottom = reg.func_94245_a(this.bottomTexture);
        this.iconFront = reg.func_94245_a(this.frontTexture);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        IIcon iIcon;
        int realMeta = ((BlockMachineMeta)this.parent).getRotationMeta(meta);
        ForgeDirection sideFD = ForgeDirection.getOrientation((int)side);
        switch (sideFD) {
            case UP: {
                iIcon = this.iconTop;
                break;
            }
            case DOWN: {
                iIcon = this.iconBottom;
                break;
            }
            default: {
                ForgeDirection front = CoordHelper.rotateForgeDirection(ForgeDirection.SOUTH, realMeta);
                if (sideFD == front) {
                    iIcon = this.iconFront;
                    break;
                }
                iIcon = this.field_149761_L;
                break;
            }
        }
        return iIcon;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityBlockScale();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        TileEntity tileEntity = worldIn.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityBlockScale) {
            TileEntityBlockScale tileScale = (TileEntityBlockScale)tileEntity;
            tileScale.doUpdate();
        }
    }
}

