/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.state;

import java.util.Arrays;
import java.util.EnumSet;
import me.jellysquid.mods.sodium.client.gl.array.GlVertexArray;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferTarget;
import me.jellysquid.mods.sodium.client.gl.func.GlFunctions;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public class GlStateTracker {
    private static final int UNASSIGNED_HANDLE = -1;
    private final int[] bufferState = new int[GlBufferTarget.COUNT];
    private final EnumSet<GlBufferTarget> mutatedBuffers = EnumSet.noneOf(GlBufferTarget.class);
    private int vertexArrayState;

    public GlStateTracker() {
        this.clearRestoreState();
    }

    public boolean makeBufferActive(GlBufferTarget target, GlBuffer buffer) {
        return this.makeBufferActive(target, buffer == null ? 0 : buffer.handle());
    }

    private boolean makeBufferActive(GlBufferTarget target, int buffer) {
        int prevBuffer = this.bufferState[target.ordinal()];
        this.bufferState[target.ordinal()] = buffer;
        this.mutatedBuffers.add(target);
        return prevBuffer != buffer;
    }

    public boolean makeVertexArrayActive(GlVertexArray array) {
        return this.makeVertexArrayActive(array == null ? 0 : array.handle());
    }

    private boolean makeVertexArrayActive(int array) {
        int prevArray = this.vertexArrayState;
        this.vertexArrayState = array;
        return prevArray != array;
    }

    public void applyRestoreState() {
        this.mutatedBuffers.forEach(target -> GL15.glBindBuffer((int)target.getTargetParameter(), (int)0));
        this.mutatedBuffers.clear();
        if (GlFunctions.isVertexArraySupported()) {
            GL30.glBindVertexArray((int)0);
        }
    }

    public void clearRestoreState() {
        Arrays.fill(this.bufferState, -1);
        this.vertexArrayState = -1;
    }
}

