/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.utils.BQThreadedIO;
import betterquesting.api2.utils.Tuple2;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.questing.QuestLineDatabase;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;

public class NetChapterSync {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:chapter_sync");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetChapterSync::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetChapterSync::onClient);
        }
    }

    public static void sendSync(@Nullable EntityPlayerMP player, @Nullable Collection<UUID> chapterIDs) {
        if (chapterIDs != null && chapterIDs.isEmpty()) {
            return;
        }
        BQThreadedIO.INSTANCE.enqueue(() -> {
            NBTTagList data = new NBTTagList();
            QuestLineDatabase chapterSubset = chapterIDs == null ? QuestLineDatabase.INSTANCE : QuestLineDatabase.INSTANCE.filterKeys(chapterIDs);
            for (Map.Entry chapter : chapterSubset.entrySet()) {
                NBTTagCompound entry = new NBTTagCompound();
                NBTConverter.UuidValueType.QUEST_LINE.writeId((UUID)chapter.getKey(), entry);
                entry.func_74782_a("config", ((IQuestLine)chapter.getValue()).writeToNBT((NBTBase)new NBTTagCompound(), null));
                data.func_74742_a((NBTBase)entry);
            }
            List<Map.Entry<UUID, IQuestLine>> allSort = QuestLineDatabase.INSTANCE.getOrderedEntries();
            List aryOrder = Lists.transform(allSort, Map.Entry::getKey);
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74757_a("merge", chapterIDs != null);
            payload.func_74782_a("data", (NBTBase)data);
            payload.func_74782_a("order", (NBTBase)NBTConverter.UuidValueType.QUEST_LINE.writeIds(aryOrder));
            if (player == null) {
                PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
            } else {
                PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestSync(@Nullable Collection<UUID> chapterIDs) {
        NBTTagCompound payload = new NBTTagCompound();
        if (chapterIDs != null) {
            payload.func_74782_a("requestIDs", (NBTBase)NBTConverter.UuidValueType.QUEST_LINE.writeIds(chapterIDs));
        }
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        NBTTagCompound payload = message.func_76341_a();
        List<UUID> reqIDs = !payload.func_74764_b("requestIDs") ? null : NBTConverter.UuidValueType.QUEST_LINE.readIds(payload, "requestIDs");
        NetChapterSync.sendSync(message.func_76340_b(), reqIDs);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        NBTTagList data = message.func_150295_c("data", 10);
        if (!message.func_74767_n("merge")) {
            QuestLineDatabase.INSTANCE.clear();
        }
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound tag = data.func_150305_b(i);
            Optional<UUID> chapterIDOptional = NBTConverter.UuidValueType.QUEST_LINE.tryReadId(tag);
            if (!chapterIDOptional.isPresent()) continue;
            UUID chapterID = chapterIDOptional.get();
            IQuestLine chapter = (IQuestLine)QuestLineDatabase.INSTANCE.get(chapterID);
            if (chapter == null) {
                chapter = QuestLineDatabase.INSTANCE.createNew(chapterID);
            }
            chapter.readFromNBT((NBTBase)tag.func_74775_l("config"), false);
        }
        List<UUID> aryOrder = NBTConverter.UuidValueType.QUEST_LINE.readIds(message, "order");
        for (int i = 0; i < aryOrder.size(); ++i) {
            QuestLineDatabase.INSTANCE.setOrderIndex(aryOrder.get(i), i);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.CHAPTER));
    }
}

