/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.parts.IPartRenderHelper;
import appeng.client.texture.CableBusTextures;
import appeng.parts.reporting.AbstractPartReporting;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractPartPanel
extends AbstractPartReporting {
    private static final CableBusTextures FRONT_BRIGHT_ICON = CableBusTextures.PartMonitor_Bright;
    private static final CableBusTextures FRONT_DARK_ICON = CableBusTextures.PartMonitor_Colored;
    private static final CableBusTextures FRONT_COLORED_ICON = CableBusTextures.PartMonitor_Colored;

    public AbstractPartPanel(ItemStack is) {
        super(is, false);
    }

    @Override
    public CableBusTextures getFrontBright() {
        return FRONT_BRIGHT_ICON;
    }

    @Override
    public CableBusTextures getFrontColored() {
        return FRONT_COLORED_ICON;
    }

    @Override
    public CableBusTextures getFrontDark() {
        return FRONT_DARK_ICON;
    }

    @Override
    public boolean isLightSource() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        IIcon sideTexture = CableBusTextures.PartMonitorSides.getIcon();
        IIcon backTexture = CableBusTextures.PartMonitorBack.getIcon();
        rh.setTexture(sideTexture, sideTexture, backTexture, this.getItemStack().func_77954_c(), sideTexture, sideTexture);
        rh.renderInventoryBox(renderer);
        rh.setInvColor(this.getBrightnessColor());
        rh.renderInventoryFace(this.getFrontBright().getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        IIcon sideTexture = CableBusTextures.PartMonitorSides.getIcon();
        IIcon backTexture = CableBusTextures.PartMonitorBack.getIcon();
        rh.setTexture(sideTexture, sideTexture, backTexture, this.getItemStack().func_77954_c(), sideTexture, sideTexture);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        Tessellator tess = Tessellator.field_78398_a;
        if (this.getLightLevel() > 0) {
            int l = 13;
            tess.func_78380_c(0xD000D0);
        }
        tess.func_78378_d(this.getBrightnessColor());
        rh.renderFace(x, y, z, this.getFrontBright().getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
    }

    protected abstract int getBrightnessColor();
}

