/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.ItemSlot;
import appeng.util.item.ItemFilterList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class MEMonitorIInventory
implements IMEMonitor<IAEItemStack> {
    private final InventoryAdaptor adaptor;
    private final IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
    private final HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap();
    private final NavigableMap<Integer, CachedItemStack> memory;
    private BaseActionSource mySource;
    private StorageFilter mode = StorageFilter.EXTRACTABLE_ONLY;
    private boolean init = false;

    public MEMonitorIInventory(InventoryAdaptor adaptor) {
        this.adaptor = adaptor;
        this.memory = new ConcurrentSkipListMap<Integer, CachedItemStack>();
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
        ItemStack out = null;
        out = type == Actionable.SIMULATE ? this.adaptor.simulateAdd(input.getItemStack()) : this.adaptor.addItems(input.getItemStack());
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        if (out == null) {
            return null;
        }
        IAEItemStack o = input.copy();
        o.setStackSize(out.field_77994_a);
        return o;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable type, BaseActionSource src) {
        ItemStack out = null;
        int toExtract = (int)Math.min(Integer.MAX_VALUE, request.getStackSize());
        out = type == Actionable.SIMULATE ? this.adaptor.simulateRemove(toExtract, request.getItemStack(), null) : this.adaptor.removeItems(toExtract, request.getItemStack(), null);
        if (out == null) {
            return null;
        }
        IAEItemStack o = request.copy();
        o.setStackSize(out.field_77994_a);
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        return o;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    public TickRateModulation onTick() {
        LinkedList<IAEItemStack> changes = new LinkedList<IAEItemStack>();
        this.list.resetStatus();
        int high = 0;
        boolean changed = false;
        for (ItemSlot is : this.adaptor) {
            IAEItemStack stack;
            ItemStack oldIS;
            CachedItemStack old = (CachedItemStack)this.memory.get(is.getSlot());
            high = Math.max(high, is.getSlot());
            ItemStack newIS = !is.isExtractable() && this.getMode() == StorageFilter.EXTRACTABLE_ONLY ? null : is.getItemStack();
            ItemStack itemStack = oldIS = old == null ? null : old.itemStack;
            if (this.isDifferent(newIS, oldIS)) {
                CachedItemStack cis = new CachedItemStack(is.getItemStack());
                this.memory.put(is.getSlot(), cis);
                if (old != null && old.aeStack != null) {
                    old.aeStack.setStackSize(-old.aeStack.getStackSize());
                    changes.add(old.aeStack);
                }
                if (cis.aeStack != null) {
                    changes.add(cis.aeStack);
                    this.list.add(cis.aeStack);
                }
                changed = true;
                continue;
            }
            int newSize = newIS == null ? 0 : newIS.field_77994_a;
            int diff = newSize - (oldIS == null ? 0 : oldIS.field_77994_a);
            IAEItemStack iAEItemStack = stack = old == null || old.aeStack == null ? AEApi.instance().storage().createItemStack(newIS) : old.aeStack.copy();
            if (stack != null) {
                stack.setStackSize(newSize);
                this.list.add(stack);
            }
            if (diff == 0 || stack == null) continue;
            CachedItemStack cis = new CachedItemStack(is.getItemStack());
            this.memory.put(is.getSlot(), cis);
            IAEItemStack a = stack.copy();
            a.setStackSize(diff);
            changes.add(a);
            changed = true;
        }
        NavigableMap<Integer, CachedItemStack> end = this.memory.tailMap(high, false);
        if (!end.isEmpty()) {
            for (CachedItemStack cis : end.values()) {
                if (cis == null || cis.aeStack == null) continue;
                IAEItemStack a = cis.aeStack.copy();
                a.setStackSize(-a.getStackSize());
                changes.add(a);
                changed = true;
            }
            end.clear();
        }
        if (!changes.isEmpty()) {
            this.postDifference(changes);
        }
        return changed ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a == b && b == null) {
            return false;
        }
        if (a == null && b != null || a != null && b == null) {
            return true;
        }
        return !Platform.isSameItemPrecise(a, b);
    }

    private void postDifference(Iterable<IAEItemStack> a) {
        if (a != null) {
            Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> l = i.next();
                IMEMonitorHandlerReceiver<IAEItemStack> key = l.getKey();
                if (key.isValid(l.getValue())) {
                    key.postChange(this, a, this.getActionSource());
                    continue;
                }
                i.remove();
            }
        }
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEItemStack input) {
        return false;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList out, int iteration) {
        if (!this.init) {
            this.onTick();
            this.init = true;
        }
        for (CachedItemStack is : this.memory.values()) {
            out.addStorage(is.aeStack);
        }
        if (out instanceof ItemFilterList) {
            this.adaptor.getAvailableItems(out, iteration);
        }
        return out;
    }

    @Override
    public IAEItemStack getAvailableItem(@Nonnull IAEItemStack request, int iteration) {
        long count = 0L;
        if (!this.init) {
            this.onTick();
            this.init = true;
        }
        for (CachedItemStack is : this.memory.values()) {
            if (is == null || is.aeStack == null || is.aeStack.getStackSize() <= 0L || !is.aeStack.isSameType(request) || (count += is.aeStack.getStackSize()) >= 0L) continue;
            count = Long.MAX_VALUE;
            break;
        }
        return count == 0L ? null : (IAEItemStack)request.copy().setStackSize(count);
    }

    @Override
    public IItemList<IAEItemStack> getStorageList() {
        return this.list;
    }

    public StorageFilter getMode() {
        return this.mode;
    }

    public void setMode(StorageFilter mode) {
        this.mode = mode;
    }

    private BaseActionSource getActionSource() {
        return this.mySource;
    }

    public void setActionSource(BaseActionSource mySource) {
        this.mySource = mySource;
    }

    private static class CachedItemStack {
        private final ItemStack itemStack;
        private final IAEItemStack aeStack;

        public CachedItemStack(ItemStack is) {
            if (is == null) {
                this.itemStack = null;
                this.aeStack = null;
            } else {
                this.itemStack = is.func_77946_l();
                this.aeStack = AEApi.instance().storage().createItemStack(is);
            }
        }
    }
}

