/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.neid.asm.transformer;

import com.gtnewhorizons.neid.asm.AsmTransformException;
import com.gtnewhorizons.neid.asm.AsmUtil;
import com.gtnewhorizons.neid.asm.IClassNodeTransformer;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class FmlRegistry
implements IClassNodeTransformer {
    @Override
    public String[] getTargetClass() {
        return new String[]{"cpw.mods.fml.common.registry.GameData", "cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry"};
    }

    @Override
    public void transform(ClassNode cn, boolean obfuscated) {
        FieldNode field = AsmUtil.findField(cn, "MAX_BLOCK_ID", true);
        if (field != null) {
            field.value = Short.MAX_VALUE;
        }
        boolean found = false;
        for (MethodNode method : cn.methods) {
            if (!AsmUtil.modifyIntConstantInMethod(method, 4095, Short.MAX_VALUE, true)) continue;
            found = true;
        }
        if (!found) {
            throw new AsmTransformException("can't find 4095 constant in any method");
        }
    }
}

