/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.overlay;

import com.caedis.duradisplay.config.ConfigDurabilityLike;
import com.caedis.duradisplay.config.DuraDisplayConfig;
import com.caedis.duradisplay.overlay.OverlayDurabilityLike;
import com.caedis.duradisplay.overlay.OverlayGadgets;
import com.caedis.duradisplay.utils.ColorType;
import com.caedis.duradisplay.utils.DurabilityFormatter;
import com.caedis.duradisplay.utils.DurabilityLikeInfo;
import com.caedis.duradisplay.utils.ModSelfDrawnBar;
import gregtech.api.items.ItemRadioactiveCell;
import ic2.api.item.ICustomDamageItem;
import ic2.core.item.armor.ItemArmorFluidTank;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class OverlayDurability
extends OverlayDurabilityLike {
    public OverlayDurability() {
        super(new ConfigDurabilityLike(true, OverlayDurabilityLike.Style.Text, DurabilityFormatter.Format.percent, 2, false, true, 65280, ColorType.RYGDurability, new double[]{30.0, 70.0}, new int[]{0xFF0000, 0x55FF00, 65280}, true, 0, true){

            @Override
            public void postLoadConfig() {
                if (this.enabled && DuraDisplayConfig.Enable) {
                    ModSelfDrawnBar.changeDurabilitybar(false);
                } else {
                    ModSelfDrawnBar.restoreDurabilitybar();
                }
                this.configCategory.setComment("Durability is the default module that shows durability of items\n");
            }

            @Override
            @NotNull
            public String category() {
                return "durability";
            }
        });
        this.addHandler("gregtech.api.items.MetaBaseItem", OverlayDurability::handleGregTech);
        this.addHandler("gregtech.api.items.ItemRadioactiveCell", OverlayDurability::handleGregTechRadioactiveCell);
        this.addHandler("tconstruct.library.weaponry.AmmoItem", i -> null);
        this.addHandler("appeng.items.tools.powered.powersink.AEBasePoweredItem", i -> null);
        this.addHandler("ic2.api.item.IElectricItem", i -> null);
        this.addHandler("tconstruct.library.tools.ToolCore", OverlayDurability::handleToolCore);
        this.addHandler("ic2.core.item.armor.ItemArmorFluidTank", OverlayDurability::handleItemArmorFluidTank);
        this.addHandler("ic2.api.item.ICustomDamageItem", OverlayDurability::handleICustomDamageItem);
        this.addHandler("vazkii.botania.common.item.brew.ItemBrewBase", i -> null);
        this.addHandler("WayofTime.alchemicalWizardry.common.items.potion.AlchemyFlask", i -> null);
        this.addHandler("WayofTime.alchemicalWizardry.common.items.ScribeTool", i -> null);
        this.addHandler("buildcraft.core.ItemPaintbrush", i -> null);
        this.addHandler("ic2.core.item.tool.ItemToolPainter", i -> null);
        this.addHandler("thaumcraft.api.IScribeTools", i -> null);
        this.addHandler("net.minecraft.item.Item", OverlayDurability::handleDefault);
    }

    @Override
    @NotNull
    public ConfigDurabilityLike config() {
        return this.config;
    }

    public static DurabilityLikeInfo handleDefault(@NotNull ItemStack stack) {
        Item item = stack.func_77973_b();
        assert (item != null);
        if (!item.func_77645_m()) {
            return null;
        }
        if (OverlayGadgets.AllowListUnLocalized.contains(stack.func_77977_a())) {
            return null;
        }
        double max = item.getMaxDamage(stack);
        double current = max - (double)item.getDamage(stack);
        return new DurabilityLikeInfo(current, max);
    }

    public static DurabilityLikeInfo handleGregTech(@NotNull ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_74764_b("GT.ToolStats")) {
            return null;
        }
        NBTTagCompound ts = nbt.func_74775_l("GT.ToolStats");
        double damage = ts.func_74763_f("Damage");
        double max = ts.func_74763_f("MaxDamage");
        double current = max - damage;
        return new DurabilityLikeInfo(current, max);
    }

    public static DurabilityLikeInfo handleToolCore(@NotNull ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("InfiTool")) {
            return null;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74762_e("Unbreaking") < 10) {
            int damage = tags.func_74762_e("Damage");
            int max = tags.func_74762_e("TotalDurability");
            int current = max - damage;
            return new DurabilityLikeInfo(current, max);
        }
        return null;
    }

    public static DurabilityLikeInfo handleGregTechRadioactiveCell(@NotNull ItemStack stack) {
        ItemRadioactiveCell bei = (ItemRadioactiveCell)stack.func_77973_b();
        assert (bei != null);
        double damage = bei.getDamageOfStack(stack);
        double max = bei.getMaxDamageEx();
        double current = max - damage;
        return new DurabilityLikeInfo(current, max);
    }

    public static DurabilityLikeInfo handleItemArmorFluidTank(@NotNull ItemStack stack) {
        ItemArmorFluidTank bei = (ItemArmorFluidTank)stack.func_77973_b();
        assert (bei != null);
        return new DurabilityLikeInfo(bei.getCharge(stack), bei.getCapacity(stack));
    }

    public static DurabilityLikeInfo handleICustomDamageItem(@NotNull ItemStack stack) {
        ICustomDamageItem bei = (ICustomDamageItem)stack.func_77973_b();
        assert (bei != null);
        double damage = bei.getCustomDamage(stack);
        double max = bei.getMaxCustomDamage(stack);
        double current = max - damage;
        return new DurabilityLikeInfo(current, max);
    }
}

