/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.config;

import com.caedis.duradisplay.config.Config;
import com.caedis.duradisplay.overlay.OverlayDurabilityLike;
import com.caedis.duradisplay.utils.ColorType;
import com.caedis.duradisplay.utils.ConfigLoad;
import com.caedis.duradisplay.utils.DurabilityFormatter;
import java.util.Arrays;
import java.util.regex.Pattern;

public abstract class ConfigDurabilityLike
extends Config {
    public boolean enabled;
    public OverlayDurabilityLike.Style style;
    public DurabilityFormatter.Format textFormat;
    public int numPadPosition;
    public boolean showWhenFull;
    public boolean showWhenEmpty;
    public int color;
    public ColorType colorType;
    public double[] colorThreshold;
    public int[] threeColors;
    public boolean smoothBar;
    public int barOffset;
    public boolean showBackground;

    protected ConfigDurabilityLike(boolean enabled, OverlayDurabilityLike.Style style, DurabilityFormatter.Format textFormat, int numPadPosition, boolean showWhenFull, boolean showWhenEmpty, int color, ColorType colorType, double[] colorThreshold, int[] threeColors, boolean smoothBar, int barOffset, boolean showBackground) {
        this.enabled = enabled;
        this.style = style;
        this.textFormat = textFormat;
        this.numPadPosition = numPadPosition;
        this.showWhenFull = showWhenFull;
        this.showWhenEmpty = showWhenEmpty;
        this.color = color;
        this.colorType = colorType;
        this.colorThreshold = colorThreshold;
        this.threeColors = threeColors;
        this.smoothBar = smoothBar;
        this.barOffset = barOffset;
        this.showBackground = showBackground;
    }

    @Override
    public void loadConfig() {
        this.enabled = this.config.getBoolean("Enable", this.category(), this.enabled, String.format("Enable %s module", this.category()));
        this.style = ConfigLoad.loadEnum(this.category(), "Style", this.style, "Style of the Overlay, can be Text, Bar, or VerticalBar");
        this.numPadPosition = this.config.getInt("Position", this.category() + ".StyleConfig.Text", this.numPadPosition, 1, 9, String.format("Location in item where the %s percentage will be (numpad style)", this.category()));
        this.textFormat = ConfigLoad.loadEnum(this.category() + ".StyleConfig.Text", "TextFormat", this.textFormat, "Format of the text");
        this.showWhenFull = this.config.getBoolean("ShowWhenFull", this.category(), this.showWhenFull, String.format("Show %s percentage when item is undamaged/full", this.category()));
        this.showWhenEmpty = this.config.getBoolean("ShowWhenEmpty", this.category(), this.showWhenEmpty, String.format("Show %s percentage when empty", this.category()));
        this.colorType = ConfigLoad.loadEnum(this.category() + ".Color", "ColorType", this.colorType, "ColorType of the Overlay, can be RYGDurability, Threshold, Vanilla, Single, Smooth");
        this.colorThreshold = Arrays.stream(this.config.get(this.category() + ".Color", "ColorThresholds", this.colorThreshold, "List of numbers in ascending order from 0-100 that set the thresholds for durability color mapping. Colors are the list of colors in ThreeColors\nBy default from Red -> Yellow -> Green by default", 0.0, 100.0, true, 2).getDoubleList()).sorted().toArray();
        Pattern hexPattern = Pattern.compile("^(?:[0-9a-fA-F]{3}){1,2}$");
        String colorCheck = this.config.getString("Color", this.category() + ".Color", Integer.toHexString(this.color), "Color of the Overlay (hex code, no prefix)", hexPattern);
        this.color = Integer.parseInt(colorCheck.replace("#", ""), 16);
        String[] threeColorsCheck = this.config.get(this.category() + ".Color", "ThreeColors", (String[])Arrays.stream(this.threeColors).mapToObj(Integer::toHexString).toArray(String[]::new), "Colors used in Threshold/Smooth color mode (hex code, no prefix)", true, 3, hexPattern).getStringList();
        this.threeColors = Arrays.stream(threeColorsCheck).mapToInt(s -> Integer.parseInt(s.replace("#", ""), 16)).toArray();
        this.smoothBar = this.config.getBoolean("SmoothBar", this.category() + ".StyleConfig.Bars", this.smoothBar, "Smooth the bar length");
        this.barOffset = this.config.getInt("BarOffset", this.category() + ".StyleConfig.Bars", this.barOffset, 0, 16, "Offset the bar by this amount");
        this.showBackground = this.config.getBoolean("ShowBackground", this.category() + ".StyleConfig.Bars", this.showBackground, "Show bar background");
        this.postLoadConfig();
    }

    public abstract void postLoadConfig();
}

