/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.org.slf4j.helpers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import unilib.external.org.slf4j.IMarkerFactory;
import unilib.external.org.slf4j.Marker;
import unilib.external.org.slf4j.helpers.MarkerWrapper;

public class Log4jMarkerFactory
implements IMarkerFactory {
    private final ConcurrentMap<String, Marker> markerMap = new ConcurrentHashMap<String, Marker>();

    @Override
    public Marker getMarker(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Marker name must not be null");
        }
        Marker marker = (Marker)this.markerMap.get(name);
        if (marker != null) {
            return marker;
        }
        marker = new MarkerWrapper(name);
        Marker existing = this.markerMap.putIfAbsent(name, marker);
        return existing == null ? marker : existing;
    }

    @Override
    public boolean exists(String name) {
        return this.markerMap.containsKey(name);
    }

    @Override
    public boolean detachMarker(String name) {
        return false;
    }

    @Override
    public Marker getDetachedMarker(String name) {
        return new MarkerWrapper(name);
    }
}

