/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.enderio;

import crazypants.enderio.machine.hypercube.HyperCubeRegister;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.ServerChannelRegister;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import logisticspipes.proxy.interfaces.IEnderIOProxy;
import net.minecraft.tileentity.TileEntity;

public class EnderIOProxy
implements IEnderIOProxy {
    @Override
    public boolean isHyperCube(TileEntity tile) {
        return tile instanceof TileHyperCube;
    }

    @Override
    public boolean isTransceiver(TileEntity tile) {
        return tile instanceof TileTransceiver;
    }

    @Override
    public List<TileEntity> getConnectedHyperCubes(TileEntity tile) {
        List cons = HyperCubeRegister.instance.getCubesForChannel(((TileHyperCube)tile).getChannel());
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
        for (TileHyperCube cube : cons) {
            if (cube == tile) continue;
            tiles.add((TileEntity)cube);
        }
        return tiles;
    }

    @Override
    public List<TileEntity> getConnectedTransceivers(TileEntity tile) {
        TileTransceiver transceiver = (TileTransceiver)tile;
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
        Channel channel = (Channel)transceiver.getRecieveChannels(ChannelType.ITEM).iterator().next();
        for (TileTransceiver t : ServerChannelRegister.instance.getIterator(channel)) {
            if (t == transceiver) continue;
            Set receiveChannels = t.getRecieveChannels(ChannelType.ITEM);
            Set sendChannels = t.getSendChannels(ChannelType.ITEM);
            if (receiveChannels.size() != 1 || sendChannels.size() != 1 || !channel.equals(receiveChannels.iterator().next()) || !channel.equals(sendChannels.iterator().next())) continue;
            tiles.add((TileEntity)t);
        }
        return tiles;
    }

    @Override
    public boolean isSendAndReceive(TileEntity tile) {
        if (tile instanceof TileHyperCube) {
            return TileHyperCube.IoMode.BOTH == ((TileHyperCube)tile).getModeForChannel(TileHyperCube.SubChannel.ITEM);
        }
        if (tile instanceof TileTransceiver) {
            Set receiveChannels = ((TileTransceiver)tile).getRecieveChannels(ChannelType.ITEM);
            Set sendChannels = ((TileTransceiver)tile).getSendChannels(ChannelType.ITEM);
            return receiveChannels.size() == 1 && sendChannels.size() == 1 && ((Channel)receiveChannels.iterator().next()).equals(sendChannels.iterator().next());
        }
        return false;
    }

    @Override
    public boolean isEnderIO() {
        return true;
    }
}

