/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import com.google.common.base.Objects;
import cpw.mods.fml.common.FMLCommonHandler;

public class ThreadOperationTimer
extends Thread {
    private final Thread thread;
    private Object operation;
    private long opTime;
    private long limit;

    private ThreadOperationTimer(Thread thread, int limit) {
        super(thread.getName() + " Operation Timer");
        this.thread = thread;
        this.limit = limit;
    }

    public synchronized void setLimit(int limit) {
        this.limit = limit;
    }

    public void reset() {
        this.reset(null);
    }

    public synchronized void reset(Object op) {
        this.operation = op;
        this.opTime = System.currentTimeMillis();
    }

    public synchronized void update(Object op) {
        if (!Objects.equal((Object)this.operation, (Object)op)) {
            this.operation = op;
            this.opTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (FMLCommonHandler.instance().findContainerFor((Object)"NotEnoughItems").getVersion().contains("$")) {
            return;
        }
        while (this.thread.isAlive()) {
            ThreadOperationTimer threadOperationTimer = this;
            synchronized (threadOperationTimer) {
                if (this.operation != null && System.currentTimeMillis() - this.opTime > this.limit) {
                    this.thread.stop();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static ThreadOperationTimer start(Thread thread, int limit) {
        ThreadOperationTimer t = new ThreadOperationTimer(thread, limit);
        t.start();
        return t;
    }

    public static class TimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = -8621458005263888185L;
        public final Object operation;

        public TimeoutException(String msg, Object op) {
            super(msg);
            this.operation = op;
        }
    }
}

