/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.network;

import appeng.api.networking.IGrid;
import com.projecturanus.betterp2p.network.PlayerRequest;
import com.projecturanus.betterp2p.network.data.GridServerCache;
import com.projecturanus.betterp2p.network.data.MemoryInfo;
import com.projecturanus.betterp2p.network.packet.C2SCloseGui;
import com.projecturanus.betterp2p.network.packet.C2SLinkP2P;
import com.projecturanus.betterp2p.network.packet.C2SRefreshP2PList;
import com.projecturanus.betterp2p.network.packet.C2SRenameP2P;
import com.projecturanus.betterp2p.network.packet.C2STypeChange;
import com.projecturanus.betterp2p.network.packet.C2SUnlinkP2P;
import com.projecturanus.betterp2p.network.packet.C2SUpdateMemoryInfo;
import com.projecturanus.betterp2p.network.packet.ClientOpenGuiHandler;
import com.projecturanus.betterp2p.network.packet.ClientUpdateP2PHandler;
import com.projecturanus.betterp2p.network.packet.S2COpenGui;
import com.projecturanus.betterp2p.network.packet.S2CUpdateP2P;
import com.projecturanus.betterp2p.network.packet.ServerCloseGuiHandler;
import com.projecturanus.betterp2p.network.packet.ServerLinkP2PHandler;
import com.projecturanus.betterp2p.network.packet.ServerRefreshP2PListHandler;
import com.projecturanus.betterp2p.network.packet.ServerRenameP2PTunnel;
import com.projecturanus.betterp2p.network.packet.ServerTypeChangeHandler;
import com.projecturanus.betterp2p.network.packet.ServerUnlinkP2PHandler;
import com.projecturanus.betterp2p.network.packet.ServerUpdateInfoHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u001e\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/projecturanus/betterp2p/network/ModNetwork;", "", "<init>", "()V", "channel", "Lcpw/mods/fml/common/network/simpleimpl/SimpleNetworkWrapper;", "getChannel", "()Lcpw/mods/fml/common/network/simpleimpl/SimpleNetworkWrapper;", "playerState", "", "Ljava/util/UUID;", "Lcom/projecturanus/betterp2p/network/PlayerRequest;", "getPlayerState", "()Ljava/util/Map;", "networkWorker", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "registerNetwork", "", "requestP2PList", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "type", "", "requestP2PUpdate", "initConnection", "grid", "Lappeng/api/networking/IGrid;", "info", "Lcom/projecturanus/betterp2p/network/data/MemoryInfo;", "removeConnection", "stop", "betterp2p"})
public final class ModNetwork {
    @NotNull
    public static final ModNetwork INSTANCE = new ModNetwork();
    @NotNull
    private static final SimpleNetworkWrapper channel;
    @NotNull
    private static final Map<UUID, PlayerRequest> playerState;
    private static ScheduledThreadPoolExecutor networkWorker;

    private ModNetwork() {
    }

    @NotNull
    public final SimpleNetworkWrapper getChannel() {
        return channel;
    }

    @NotNull
    public final Map<UUID, PlayerRequest> getPlayerState() {
        return playerState;
    }

    public final void registerNetwork() {
        int id = 0;
        channel.registerMessage(ClientOpenGuiHandler.class, S2COpenGui.class, id++, Side.CLIENT);
        channel.registerMessage(ClientUpdateP2PHandler.class, S2CUpdateP2P.class, id++, Side.CLIENT);
        channel.registerMessage(ServerLinkP2PHandler.class, C2SLinkP2P.class, id++, Side.SERVER);
        channel.registerMessage(ServerCloseGuiHandler.class, C2SCloseGui.class, id++, Side.SERVER);
        channel.registerMessage(ServerUpdateInfoHandler.class, C2SUpdateMemoryInfo.class, id++, Side.SERVER);
        channel.registerMessage(ServerRenameP2PTunnel.class, C2SRenameP2P.class, id++, Side.SERVER);
        channel.registerMessage(ServerRefreshP2PListHandler.class, C2SRefreshP2PList.class, id++, Side.SERVER);
        channel.registerMessage(ServerUnlinkP2PHandler.class, C2SUnlinkP2P.class, id++, Side.SERVER);
        channel.registerMessage(ServerTypeChangeHandler.class, C2STypeChange.class, id, Side.SERVER);
        networkWorker = new ScheduledThreadPoolExecutor(1, ModNetwork::registerNetwork$lambda$0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestP2PList(@NotNull EntityPlayer player, int type) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map<UUID, PlayerRequest> map = playerState;
        synchronized (map) {
            boolean bl = false;
            PlayerRequest playerRequest = playerState.get(player.func_110124_au());
            if (playerRequest == null) {
                return;
            }
            PlayerRequest playerState = playerRequest;
            GridServerCache cache = playerState.getGridCache();
            cache.setType(type);
            if (playerState.getUpdateReady$betterp2p() + 250L < System.currentTimeMillis()) {
                channel.sendTo((IMessage)new S2CUpdateP2P(cache.retrieveP2PList(), true), (EntityPlayerMP)player);
                playerState.setUpdateReady$betterp2p(System.currentTimeMillis() + 250L);
            } else if (!playerState.getUpdatePending$betterp2p()) {
                playerState.setUpdatePending$betterp2p(true);
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = networkWorker;
                if (scheduledThreadPoolExecutor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"networkWorker");
                    scheduledThreadPoolExecutor = null;
                }
                scheduledThreadPoolExecutor.schedule(() -> ModNetwork.requestP2PList$lambda$3$lambda$2(cache, player, playerState), playerState.getUpdateReady$betterp2p() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestP2PUpdate(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map<UUID, PlayerRequest> map = playerState;
        synchronized (map) {
            boolean bl = false;
            PlayerRequest playerRequest = playerState.get(player.func_110124_au());
            if (playerRequest == null) {
                return;
            }
            PlayerRequest playerState = playerRequest;
            GridServerCache cache = playerState.getGridCache();
            if (playerState.getUpdateReady$betterp2p() + 250L < System.currentTimeMillis()) {
                channel.sendTo((IMessage)new S2CUpdateP2P(cache.getP2PUpdates(), false, 2, null), (EntityPlayerMP)player);
                playerState.setUpdateReady$betterp2p(System.currentTimeMillis() + 250L);
            } else if (!playerState.getUpdatePending$betterp2p()) {
                playerState.setUpdatePending$betterp2p(true);
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = networkWorker;
                if (scheduledThreadPoolExecutor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"networkWorker");
                    scheduledThreadPoolExecutor = null;
                }
                scheduledThreadPoolExecutor.schedule(() -> ModNetwork.requestP2PUpdate$lambda$6$lambda$5(cache, player, playerState), playerState.getUpdateReady$betterp2p() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void initConnection(@NotNull EntityPlayer player, @NotNull IGrid grid, @NotNull MemoryInfo info2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        GridServerCache cache = new GridServerCache(grid, player, info2.getType());
        playerState.put(player.func_110124_au(), new PlayerRequest(false, 0L, cache, 3, null));
        channel.sendTo((IMessage)new S2COpenGui(cache.retrieveP2PList(), info2), (EntityPlayerMP)player);
    }

    public final void removeConnection(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        playerState.remove(player.func_110124_au());
    }

    public final void stop() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = networkWorker;
        if (scheduledThreadPoolExecutor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"networkWorker");
            scheduledThreadPoolExecutor = null;
        }
        scheduledThreadPoolExecutor.shutdown();
    }

    private static final Thread registerNetwork$lambda$0(Runnable it) {
        Thread th = new Thread(it);
        th.setName("BetterP2P-NetworkWorker");
        th.setDaemon(true);
        th.setPriority(1);
        return th;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void requestP2PList$lambda$3$lambda$2(GridServerCache $cache, EntityPlayer $player, PlayerRequest $playerState) {
        Map<UUID, PlayerRequest> map = playerState;
        synchronized (map) {
            boolean bl = false;
            IMessage iMessage = new S2CUpdateP2P($cache.retrieveP2PList(), true);
            Intrinsics.checkNotNull((Object)$player, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
            channel.sendTo(iMessage, (EntityPlayerMP)$player);
            $playerState.setUpdatePending$betterp2p(false);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void requestP2PUpdate$lambda$6$lambda$5(GridServerCache $cache, EntityPlayer $player, PlayerRequest $playerState) {
        Map<UUID, PlayerRequest> map = playerState;
        synchronized (map) {
            boolean bl = false;
            IMessage iMessage = new S2CUpdateP2P($cache.getP2PUpdates(), false, 2, null);
            Intrinsics.checkNotNull((Object)$player, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
            channel.sendTo(iMessage, (EntityPlayerMP)$player);
            $playerState.setUpdatePending$betterp2p(false);
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        SimpleNetworkWrapper simpleNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("betterp2p");
        Intrinsics.checkNotNullExpressionValue((Object)simpleNetworkWrapper, (String)"newSimpleChannel(...)");
        channel = simpleNetworkWrapper;
        Map map = Collections.synchronizedMap(new WeakHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        playerState = map;
    }
}

