/*
 * Decompiled with CFR 0.152.
 */
package vfyjxf.bettercrashes.utils;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import vfyjxf.bettercrashes.BetterCrashes;
import vfyjxf.bettercrashes.utils.HttpUtils;

public final class StacktraceDeobfuscator {
    private static final String MAPPING_METHODS_CSV_URL = "https://raw.githubusercontent.com/MinecraftForge/FML/1.7.10/conf/methods.csv";
    private static final String MAPPING_METHODS_CSV_HASH = "63de115ead3e848e529de81e81ada9dff694e50fb5c6d92ec1e9037fe50ca191";
    private static final boolean DEBUG_IN_DEV = false;
    private static HashMap<String, String> srgMcpMethodMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File mappings) {
        if (srgMcpMethodMap != null) {
            return;
        }
        if (!mappings.exists()) {
            BetterCrashes.logger.info("Downloading MCP method mappings to deobfuscate stacktrace");
            HttpURLConnection connection = null;
            try {
                URL mappingsURL = new URL(MAPPING_METHODS_CSV_URL);
                connection = HttpUtils.createConnection(mappingsURL);
                connection.setDoInput(true);
                connection.connect();
                try (InputStream inputStream = connection.getInputStream();){
                    boolean downloadInvalid = false;
                    try (FileOutputStream out = new FileOutputStream(mappings);){
                        int len;
                        Hasher hasher = Hashing.sha256().newHasher();
                        byte[] buffer = new byte[8192];
                        while ((len = inputStream.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                            hasher.putBytes(buffer, 0, len);
                        }
                        if (!hasher.hash().toString().equals(MAPPING_METHODS_CSV_HASH)) {
                            downloadInvalid = true;
                            BetterCrashes.logger.warn("Downloaded MCP mapping method.csv does not match expected hash. Skipping deobfuscation...");
                        }
                    }
                    if (downloadInvalid) {
                        mappings.delete();
                        return;
                    }
                }
            }
            catch (IOException e) {
                BetterCrashes.logger.warn("Failed downloading MCP mappings. Skipping deobfuscation...");
                return;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        HashMap<String, String> srgMcpMethodMap = new HashMap<String, String>();
        try (Scanner scanner = new Scanner(mappings);){
            scanner.nextLine();
            while (scanner.hasNext()) {
                String mappingLine = scanner.nextLine();
                int commaIndex = mappingLine.indexOf(44);
                String srgName = mappingLine.substring(0, commaIndex);
                String mcpName = mappingLine.substring(commaIndex + 1, commaIndex + 1 + mappingLine.substring(commaIndex + 1).indexOf(44));
                srgMcpMethodMap.put(srgName, mcpName);
            }
        }
        catch (IOException | IndexOutOfBoundsException e) {
            BetterCrashes.logger.warn("Failed to parse {}. Possible corruption. Please delete to trigger redownload.", new Object[]{mappings.getName()});
            return;
        }
        StacktraceDeobfuscator.srgMcpMethodMap = srgMcpMethodMap;
    }

    public static void deobfuscateThrowable(Throwable t) {
        ArrayDeque<Throwable> queue = new ArrayDeque<Throwable>();
        queue.add(t);
        while (!queue.isEmpty()) {
            t = (Throwable)queue.remove();
            t.setStackTrace(StacktraceDeobfuscator.deobfuscateStacktrace(t.getStackTrace()));
            if (t.getCause() != null) {
                queue.add(t.getCause());
            }
            Collections.addAll(queue, t.getSuppressed());
        }
    }

    public static StackTraceElement[] deobfuscateStacktrace(StackTraceElement[] stackTrace) {
        int index = 0;
        for (StackTraceElement el : stackTrace) {
            stackTrace[index++] = new StackTraceElement(el.getClassName(), StacktraceDeobfuscator.deobfuscateMethodName(el.getMethodName()), el.getFileName(), el.getLineNumber());
        }
        return stackTrace;
    }

    public static String deobfuscateMethodName(String srgName) {
        if (srgMcpMethodMap == null) {
            return srgName;
        }
        String mcpName = srgMcpMethodMap.get(srgName);
        return mcpName != null ? mcpName : srgName;
    }

    public static void main(String[] args) {
        StacktraceDeobfuscator.init(new File("methods.csv"));
        for (Map.Entry<String, String> entry : srgMcpMethodMap.entrySet()) {
            System.out.println(entry.getKey() + " <=> " + entry.getValue());
        }
    }
}

