/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.core.genetics.IItemStackRepresentative;
import binnie.core.resource.BinnieIcon;
import binnie.core.util.I18N;
import binnie.extrabees.genetics.ExtraBeeMutation;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public abstract class BreedingSystem
implements IItemStackRepresentative {
    public float discoveredSpeciesPercentage;
    public int totalSpeciesCount;
    public int discoveredSpeciesCount;
    public int totalSecretCount;
    public int discoveredSecretCount;
    public float discoveredBranchPercentage;
    public int totalBranchCount;
    public int discoveredBranchCount;
    protected BinnieIcon iconUndiscovered;
    protected BinnieIcon iconDiscovered;
    protected List<IAlleleSpecies> allActiveSpecies = new ArrayList<IAlleleSpecies>();
    private List<IClassification> allBranches = new ArrayList<IClassification>();
    private List<IMutation> allMutations = new ArrayList<IMutation>();
    private Map<IAlleleSpecies, List<IMutation>> resultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
    private Map<IAlleleSpecies, List<IMutation>> furtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();

    public BreedingSystem() {
        Binnie.Genetics.registerBreedingSystem(this);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public String getChromosomeName(IChromosomeType chromo) {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".chromosome." + chromo.getName());
    }

    public String getChromosomeShortName(IChromosomeType chromo) {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".chromosome." + chromo.getName() + ".short");
    }

    public String getEpitome(float discoveredPercentage) {
        int i = 0;
        if (discoveredPercentage == 1.0f) {
            i = 6;
        } else if (discoveredPercentage < 0.1f) {
            i = 0;
        } else if (discoveredPercentage < 0.3f) {
            i = 1;
        } else if (discoveredPercentage < 0.5f) {
            i = 2;
        } else if (discoveredPercentage < 0.7f) {
            i = 3;
        } else if (discoveredPercentage < 0.9f) {
            i = 4;
        } else if (discoveredPercentage < 1.0f) {
            i = 5;
        }
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".epitome." + i);
    }

    public abstract ISpeciesRoot getSpeciesRoot();

    public List<IClassification> getAllBranches() {
        return this.allBranches;
    }

    public Collection<IAlleleSpecies> getAllSpecies() {
        return this.allActiveSpecies;
    }

    public Collection<IMutation> getAllMutations() {
        return this.allMutations;
    }

    public void calculateArrays() {
        Collection allAlleles = AlleleManager.alleleRegistry.getRegisteredAlleles().values();
        this.resultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.furtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.allActiveSpecies = new ArrayList<IAlleleSpecies>();
        for (Object species : allAlleles) {
            if (this.getSpeciesRoot().getTemplate(species.getUID()) == null) continue;
            this.resultantMutations.put((IAlleleSpecies)species, new ArrayList());
            this.furtherMutations.put((IAlleleSpecies)species, new ArrayList());
            if (this.isBlacklisted((IAllele)species) || species.getUID().contains("speciesBotAlfheim")) continue;
            this.allActiveSpecies.add((IAlleleSpecies)species);
        }
        this.allMutations = new ArrayList<IMutation>();
        Collection allRegBranches = AlleleManager.alleleRegistry.getRegisteredClassifications().values();
        this.allBranches = new ArrayList<IClassification>();
        for (IClassification branch : allRegBranches) {
            if (branch.getMemberSpecies().length <= 0 || this.getSpeciesRoot().getTemplate(branch.getMemberSpecies()[0].getUID()) == null) continue;
            boolean possible = false;
            for (IAlleleSpecies species2 : branch.getMemberSpecies()) {
                if (!this.allActiveSpecies.contains(species2)) continue;
                possible = true;
                break;
            }
            if (!possible) continue;
            this.allBranches.add(branch);
        }
        if (this.getSpeciesRoot().getMutations(false) != null) {
            LinkedHashSet<IMutation> mutations = new LinkedHashSet<IMutation>();
            mutations.addAll(this.getSpeciesRoot().getMutations(false));
            if (this == Binnie.Genetics.beeBreedingSystem) {
                mutations.addAll(ExtraBeeMutation.mutations);
            }
            for (IMutation mutation : mutations) {
                this.allMutations.add(mutation);
                LinkedHashSet<IAlleleSpecies> participatingSpecies = new LinkedHashSet<IAlleleSpecies>();
                if (mutation.getAllele0() != null) {
                    participatingSpecies.add(mutation.getAllele0());
                }
                if (mutation.getAllele1() != null) {
                    participatingSpecies.add(mutation.getAllele1());
                }
                for (IAlleleSpecies species3 : participatingSpecies) {
                    if (!this.allActiveSpecies.contains(species3)) continue;
                    this.furtherMutations.get(species3).add(mutation);
                }
                if (!this.resultantMutations.containsKey(mutation.getTemplate()[0])) continue;
                this.resultantMutations.get(mutation.getTemplate()[0]).add(mutation);
            }
        }
    }

    public boolean isBlacklisted(IAllele allele) {
        return AlleleManager.alleleRegistry.isBlacklisted(allele.getUID());
    }

    public List<IMutation> getResultantMutations(IAlleleSpecies species) {
        if (this.resultantMutations.isEmpty()) {
            this.calculateArrays();
        }
        return this.resultantMutations.get(species);
    }

    public List<IMutation> getFurtherMutations(IAlleleSpecies species) {
        if (this.furtherMutations.isEmpty()) {
            this.calculateArrays();
        }
        return this.furtherMutations.get(species);
    }

    public boolean isMutationDiscovered(IMutation mutation, World world, GameProfile name) {
        return this.isMutationDiscovered(mutation, this.getSpeciesRoot().getBreedingTracker(world, name));
    }

    public boolean isMutationDiscovered(IMutation mutation, IBreedingTracker tracker) {
        return tracker == null || tracker.isDiscovered(mutation);
    }

    public boolean isSpeciesDiscovered(IAlleleSpecies species, World world, GameProfile name) {
        return this.isSpeciesDiscovered(species, this.getSpeciesRoot().getBreedingTracker(world, name));
    }

    public boolean isSpeciesDiscovered(IAlleleSpecies species, IBreedingTracker tracker) {
        return tracker == null || tracker.isDiscovered(species);
    }

    public boolean isSecret(IAlleleSpecies species) {
        return !species.isCounted();
    }

    public boolean isSecret(IClassification branch) {
        for (IAlleleSpecies species : branch.getMemberSpecies()) {
            if (this.isSecret(species)) continue;
            return false;
        }
        return true;
    }

    public Collection<IClassification> getDiscoveredBranches(World world, GameProfile player) {
        ArrayList<IClassification> branches = new ArrayList<IClassification>();
        for (IClassification branch : this.getAllBranches()) {
            boolean discovered = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.isSpeciesDiscovered(species, world, player)) continue;
                discovered = true;
            }
            if (!discovered) continue;
            branches.add(branch);
        }
        return branches;
    }

    public Collection<IClassification> getDiscoveredBranches(IBreedingTracker tracker) {
        ArrayList<IClassification> branches = new ArrayList<IClassification>();
        for (IClassification branch : this.getAllBranches()) {
            boolean discovered = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.isSpeciesDiscovered(species, tracker)) continue;
                discovered = true;
            }
            if (!discovered) continue;
            branches.add(branch);
        }
        return branches;
    }

    public Collection<IAlleleSpecies> getDiscoveredSpecies(World world, GameProfile player) {
        ArrayList<IAlleleSpecies> speciesList = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : this.getAllSpecies()) {
            if (!this.isSpeciesDiscovered(species, world, player)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public Collection<IAlleleSpecies> getDiscoveredSpecies(IBreedingTracker tracker) {
        ArrayList<IAlleleSpecies> speciesList = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : this.getAllSpecies()) {
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public List<IMutation> getDiscoveredMutations(World world, GameProfile player) {
        ArrayList<IMutation> speciesList = new ArrayList<IMutation>();
        for (IMutation species : this.getAllMutations()) {
            if (!this.isMutationDiscovered(species, world, player)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public IIcon getUndiscoveredIcon() {
        return this.iconUndiscovered.getIcon();
    }

    public IIcon getDiscoveredIcon() {
        return this.iconDiscovered.getIcon();
    }

    public abstract float getChance(IMutation var1, EntityPlayer var2, IAllele var3, IAllele var4);

    public abstract Class<? extends IBreedingTracker> getTrackerClass();

    public void syncTracker(IBreedingTracker tracker) {
        this.discoveredSpeciesPercentage = 0.0f;
        this.totalSpeciesCount = 0;
        this.discoveredSpeciesCount = 0;
        this.totalSecretCount = 0;
        this.discoveredSecretCount = 0;
        Collection<IAlleleSpecies> allSpecies = this.getAllSpecies();
        for (IAlleleSpecies species : allSpecies) {
            if (!this.isSecret(species)) {
                ++this.totalSpeciesCount;
                if (!this.isSpeciesDiscovered(species, tracker)) continue;
                ++this.discoveredSpeciesCount;
                continue;
            }
            ++this.totalSecretCount;
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            ++this.discoveredSecretCount;
        }
        this.discoveredBranchPercentage = 0.0f;
        this.totalBranchCount = 0;
        this.discoveredBranchCount = 0;
        Collection<IClassification> discoveredBranches = this.getDiscoveredBranches(tracker);
        List<IClassification> allBranches = this.getAllBranches();
        for (IClassification branch : allBranches) {
            if (this.isSecret(branch)) continue;
            ++this.totalBranchCount;
            if (!discoveredBranches.contains(branch)) continue;
            ++this.discoveredBranchCount;
        }
        this.discoveredSpeciesPercentage = this.discoveredSpeciesCount / this.totalSpeciesCount;
        this.discoveredBranchPercentage = this.discoveredBranchCount / this.totalBranchCount;
        this.onSyncBreedingTracker(tracker);
    }

    public void onSyncBreedingTracker(IBreedingTracker tracker) {
    }

    public String getEpitome() {
        return this.getEpitome(this.discoveredSpeciesPercentage);
    }

    public String getDescriptor() {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".descriptor");
    }

    public String getIdent() {
        return this.getSpeciesRoot().getUID();
    }

    public IChromosomeType getChromosome(int i) {
        for (IChromosomeType chromosome : this.getSpeciesRoot().getKaryotype()) {
            if (i != chromosome.ordinal()) continue;
            return chromosome;
        }
        return null;
    }

    public abstract int getColor();

    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (allele instanceof IAlleleBoolean) {
            return ((IAlleleBoolean)allele).getValue() ? I18N.localise("binniecore.allele.true") : I18N.localise("binniecore.allele.false");
        }
        if (allele.getName().equals("for.gui.maximum")) {
            return I18N.localise("binniecore.allele.fertility.maximum");
        }
        return allele.getName();
    }

    public String getName() {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".shortName");
    }

    @Override
    public ItemStack getItemStackRepresentative() {
        ISpeciesRoot speciesRoot = this.getSpeciesRoot();
        IIndividual first = (IIndividual)speciesRoot.getIndividualTemplates().get(0);
        return speciesRoot.getMemberStack(first, this.getDefaultType());
    }

    public String toString() {
        return this.getName();
    }

    public abstract boolean isDNAManipulable(ItemStack var1);

    public IIndividual getConversion(ItemStack stack) {
        return null;
    }

    public IIndividual getDefaultIndividual() {
        return this.getSpeciesRoot().templateAsIndividual(this.getSpeciesRoot().getDefaultTemplate());
    }

    public int getDefaultType() {
        return this.getActiveTypes()[0];
    }

    public abstract int[] getActiveTypes();

    public abstract void addExtraAlleles(IChromosomeType var1, TreeSet<IAllele> var2);

    public ItemStack getConversionStack(ItemStack stack) {
        return this.getSpeciesRoot().getMemberStack(this.getConversion(stack), this.getDefaultType());
    }

    public Collection<IChromosomeType> getActiveKaryotype() {
        return Binnie.Genetics.getActiveChromosomes(this.getSpeciesRoot());
    }

    public ItemStack getDefaultMember(String uid) {
        return this.getSpeciesRoot().getMemberStack(this.getIndividual(uid), this.getDefaultType());
    }

    public IIndividual getIndividual(String uid) {
        return this.getSpeciesRoot().templateAsIndividual(this.getSpeciesRoot().getTemplate(uid));
    }

    public IGenome getGenome(String uid) {
        return this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(uid));
    }

    public class EventHandler {
        @SubscribeEvent
        public void onSyncBreedingTracker(ForestryEvent.SyncedBreedingTracker event) {
            IBreedingTracker tracker = event.tracker;
            if (!BreedingSystem.this.getTrackerClass().isInstance(tracker)) {
                return;
            }
            BreedingSystem.this.syncTracker(tracker);
        }
    }
}

