/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import glowredman.txloader.TXLoaderCore;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MinecraftClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("net.minecraft.client.Minecraft".equals(transformedName)) {
            return MinecraftClassTransformer.transformMinecraft(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformMinecraft(byte[] basicClass) {
        TXLoaderCore.LOGGER.debug("Transforming net.minecraft.client.Minecraft");
        boolean devEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        String targetMethodName = devEnv ? "refreshResources" : "func_110436_a";
        String targetMethodInsnName = devEnv ? "reloadResources" : "func_110541_a";
        boolean success = false;
        block0: for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(targetMethodName) || !mn.desc.equals("()V")) continue;
            for (AbstractInsnNode node : mn.instructions.toArray()) {
                if (!MinecraftClassTransformer.isTargetNode(node, targetMethodInsnName)) continue;
                mn.instructions.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, "glowredman/txloader/MinecraftHook", "insertForcePack", "(Ljava/util/List;)Ljava/util/List;", false));
                success = true;
                break block0;
            }
        }
        if (!success) {
            throw new RuntimeException("TX Loader couldn't transform Minecraft!");
        }
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTargetNode(AbstractInsnNode node, String name) {
        if (!(node instanceof MethodInsnNode)) return false;
        MethodInsnNode mn = (MethodInsnNode)node;
        if (!mn.name.equals(name)) return false;
        if (!mn.desc.equals("(Ljava/util/List;)V")) return false;
        return true;
    }
}

