/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.blocks;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.items.ItemMatterCluster;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.Utils;
import mcp.mobius.betterbarrels.bspace.BSpaceStorageHandler;
import mcp.mobius.betterbarrels.common.JabbaCreativeTab;
import mcp.mobius.betterbarrels.common.StructuralLevel;
import mcp.mobius.betterbarrels.common.blocks.IBarrelStorage;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeCore;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeSide;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBarrel
extends BlockContainer {
    public static IIcon text_sidehopper = null;
    public static IIcon text_siders = null;
    public static IIcon text_lock = null;
    public static IIcon text_linked = null;
    public static IIcon text_locklinked = null;

    public BlockBarrel() {
        super(new Material(MapColor.field_151663_o){
            {
                this.func_76226_g();
                this.func_85158_p();
            }
        });
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 1);
        this.func_149663_c("blockbarrel");
        this.func_149647_a(JabbaCreativeTab.tab);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityBarrel();
    }

    public void func_149651_a(IIconRegister iconRegister) {
        text_sidehopper = iconRegister.func_94245_a("JABBA:facade_hopper");
        text_siders = iconRegister.func_94245_a("JABBA:facade_redstone");
        text_lock = iconRegister.func_94245_a("JABBA:overlay_locked");
        text_linked = iconRegister.func_94245_a("JABBA:overlay_linked");
        text_locklinked = iconRegister.func_94245_a("JABBA:overlay_lockedlinked");
        for (int i = 0; i < StructuralLevel.LEVELS.length; ++i) {
            StructuralLevel.LEVELS[i].clientData.registerBlockIcons(iconRegister, i);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack par6ItemStack) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityBarrel)) {
            BetterBarrels.log.error("TileEntity for barrel placed at (X:" + x + ", Y:" + y + ", Z:" + z + ") is " + (te == null ? "null!" : "of the wrong type(" + te.getClass().getCanonicalName() + ")!"));
            return;
        }
        TileEntityBarrel barrelEntity = (TileEntityBarrel)te;
        barrelEntity.orientation = Utils.getDirectionFacingEntity(entity, BetterBarrels.allowVerticalPlacement);
        barrelEntity.rotation = Utils.getDirectionFacingEntity(entity, false);
        barrelEntity.sideUpgrades[barrelEntity.orientation.ordinal()] = 1;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return this.removedByPlayer(world, player, x, y, z, false);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d && !player.func_70093_af()) {
            this.func_149699_a(world, x, y, z, player);
            return false;
        }
        return world.func_147468_f(x, y, z);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            ((TileEntityBarrel)tileEntity).leftClick(player);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            ((TileEntityBarrel)tileEntity).rightClick(player, side);
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = Utils.getTileEntityWithoutCreating(world, x, y, z);
        if (te == null) {
            return;
        }
        if (te instanceof TileEntityBarrel) {
            ItemStack droppedStack;
            TileEntityBarrel barrelEntity = (TileEntityBarrel)te;
            if (barrelEntity.coreUpgrades.levelStructural > 0) {
                for (int currentUpgrade = barrelEntity.coreUpgrades.levelStructural; currentUpgrade > 0; --currentUpgrade) {
                    ItemStack droppedStack2 = new ItemStack(BetterBarrels.itemUpgradeStructural, 1, currentUpgrade - 1);
                    BlockBarrel.spawnStackInWorld(world, x, y, z, droppedStack2);
                }
            }
            for (UpgradeCore core : barrelEntity.coreUpgrades.upgradeList) {
                droppedStack = new ItemStack(BetterBarrels.itemUpgradeCore, 1, core.ordinal());
                BlockBarrel.spawnStackInWorld(world, x, y, z, droppedStack);
            }
            for (int i = 0; i < 6; ++i) {
                Item upgrade = UpgradeSide.mapItem[barrelEntity.sideUpgrades[i]];
                if (upgrade == null) continue;
                droppedStack = new ItemStack(upgrade, 1, UpgradeSide.mapMeta[barrelEntity.sideUpgrades[i]]);
                BlockBarrel.spawnStackInWorld(world, x, y, z, droppedStack);
            }
            barrelEntity.setCreative(false);
            barrelEntity.setVoid(false);
            if (barrelEntity.getStorage().hasItem() && !barrelEntity.getLinked()) {
                barrelEntity.func_145845_h();
                BlockBarrel.dropBarrelContents(world, x, y, z, barrelEntity);
            }
            try {
                BSpaceStorageHandler.instance().unregisterEnderBarrel(barrelEntity.id);
            }
            catch (Exception e) {
                BetterBarrels.log.info("Tried to remove the barrel from the index without a valid entity");
            }
        } else {
            BetterBarrels.log.error("TileEntity for barrel being broken at (X:" + x + ", Y:" + y + ", Z:" + z + ") is of the wrong type(" + te.getClass().getCanonicalName() + ")!");
        }
        world.func_147475_p(x, y, z);
    }

    private static void forEachStackOfBarrel(TileEntityBarrel barrel, Consumer<ItemStack> action) {
        ItemStack stack;
        while (barrel.getStorage().getAmount() > 0 && (stack = barrel.getStorage().getStack()) != null && stack.field_77994_a != 0) {
            action.accept(stack);
        }
    }

    private static void spawnStackInWorld(World world, int x, int y, int z, ItemStack stack) {
        Random rand = world.field_73012_v;
        while (stack.field_77994_a > 0) {
            int stackSize = Math.min(stack.field_77994_a, stack.func_77976_d());
            stack.field_77994_a -= stackSize;
            ItemStack newStack = new ItemStack(stack.func_77973_b(), stackSize, stack.func_77960_j());
            if (stack.func_77942_o()) {
                newStack.func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rand.nextFloat() * 0.8f + 0.1f), (double)((float)y + rand.nextFloat() * 0.8f + 0.1f), (double)((float)z + rand.nextFloat() * 0.8f + 0.1f), newStack);
            entityItem.field_70159_w = rand.nextGaussian() * (double)0.05f;
            entityItem.field_70181_x = rand.nextGaussian() * (double)0.05f + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)0.05f;
            world.func_72838_d((Entity)entityItem);
        }
    }

    private static void dropMergedStacks(TileEntityBarrel barrel, World world, int x, int y, int z) {
        ItemStack storedStack = barrel.getStorage().getItem();
        if (storedStack.func_77985_e()) {
            ItemStack copy = storedStack.func_77946_l();
            copy.field_77994_a = barrel.getStorage().getAmount();
            BlockBarrel.dropBigStackInWorld(world, x, y, z, copy);
        } else {
            BlockBarrel.dropAllStacksOfBarrel(barrel, world, x, y, z);
        }
    }

    private static void dropBigStackInWorld(World world, int x, int y, int z, ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        Random rand = world.field_73012_v;
        float ex = rand.nextFloat() * 0.8f + 0.1f;
        float ey = rand.nextFloat() * 0.8f + 0.1f;
        float ez = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entity = new EntityItem(world, (double)((float)x + ex), (double)((float)y + ey), (double)((float)z + ez), stack);
        if (stack.func_77942_o()) {
            entity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
        }
        world.func_72838_d((Entity)entity);
    }

    private static void dropBarrelContents(World world, int x, int y, int z, TileEntityBarrel barrel) {
        int stacksToSpawn = BlockBarrel.countAmountOfStacksToSpawn(barrel);
        if (stacksToSpawn == 0) {
            return;
        }
        if (stacksToSpawn <= 64) {
            BlockBarrel.dropAllStacksOfBarrel(barrel, world, x, y, z);
        } else if (Loader.isModLoaded((String)"Avaritia")) {
            BlockBarrel.dropAvaritiaClusters(barrel, world, x, y, z);
        } else {
            BlockBarrel.dropMergedStacks(barrel, world, x, y, z);
        }
    }

    private static int countAmountOfStacksToSpawn(TileEntityBarrel barrel) {
        ItemStack stack = barrel.getStorage().getItem();
        if (stack == null || stack.func_77973_b() == null) {
            return 0;
        }
        int stackCount = 0;
        int maxStackSize = stack.func_77976_d();
        int storedItemCount = barrel.getStorage().getAmount();
        stackCount += storedItemCount / maxStackSize;
        if (storedItemCount % maxStackSize != 0) {
            ++stackCount;
        }
        return stackCount;
    }

    @Optional.Method(modid="Avaritia")
    private static void dropAvaritiaClusters(TileEntityBarrel barrel, World world, int x, int y, int z) {
        ArrayList list = new ArrayList();
        BlockBarrel.forEachStackOfBarrel(barrel, list::add);
        List clusters = ItemMatterCluster.makeClusters(list);
        for (ItemStack stack : clusters) {
            BlockBarrel.spawnStackInWorld(world, x, y, z, stack);
        }
    }

    private static void dropAllStacksOfBarrel(TileEntityBarrel barrel, World world, int x, int y, int z) {
        BlockBarrel.forEachStackOfBarrel(barrel, stack -> BlockBarrel.spawnStackInWorld(world, x, y, z, stack));
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149709_b(world, x, y, z, side);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = Utils.getTileEntityPreferNotCreating(world, x, y, z);
        if (te == null || !(te instanceof TileEntityBarrel)) {
            return 0;
        }
        return ((TileEntityBarrel)te).getRedstonePower(side);
    }

    private int redstoneToMC(int redSide) {
        switch (redSide) {
            default: {
                return 1;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: 
        }
        return 4;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = Utils.getTileEntityPreferNotCreating(world, x, y, z);
        if (te == null || !(te instanceof TileEntityBarrel)) {
            return super.canConnectRedstone(world, x, y, z, side);
        }
        TileEntityBarrel barrel = (TileEntityBarrel)te;
        return barrel.sideUpgrades[this.redstoneToMC(side)] == 4;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int dir) {
        TileEntity te = Utils.getTileEntityPreferNotCreating((IBlockAccess)world, x, y, z);
        if (te == null || !(te instanceof TileEntityBarrel)) {
            return 0;
        }
        IBarrelStorage store = ((TileEntityBarrel)te).getStorage();
        int currentAmount = store.getAmount();
        int maxStorable = store.getMaxStoredCount();
        if (currentAmount == 0) {
            return 0;
        }
        if (currentAmount == maxStorable) {
            return 15;
        }
        return MathHelper.func_76141_d((float)((float)currentAmount / (float)maxStorable * 14.0f)) + 1;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return false;
        }
        TileEntity te = Utils.getTileEntityPreferNotCreating(world, x, y, z);
        if (te == null || !(te instanceof TileEntityBarrel)) {
            return super.isSideSolid(world, x, y, z, side);
        }
        TileEntityBarrel barrel = (TileEntityBarrel)te;
        return barrel.sideUpgrades[side.ordinal()] != 1 && barrel.sideUpgrades[side.ordinal()] != 2;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return this.isSideSolid(world, x, y, z, ForgeDirection.UP);
    }

    public int func_149645_b() {
        BetterBarrels.proxy.checkRenderers();
        return BetterBarrels.blockBarrelRendererID;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = Utils.getTileEntityPreferNotCreating(world, x, y, z);
        if (te == null || !(te instanceof TileEntityBarrel)) {
            return Blocks.field_150344_f.func_149673_e(world, x, y, z, side);
        }
        TileEntityBarrel barrel = (TileEntityBarrel)te;
        int levelStructural = barrel.coreUpgrades.levelStructural;
        boolean ghosting = barrel.getStorage().isGhosting();
        boolean linked = barrel.getLinked();
        boolean sideIsLabel = barrel.sideUpgrades[side] == 1 || barrel.sideUpgrades[side] == 2;
        IIcon ret = StructuralLevel.LEVELS[levelStructural].clientData.getIconLabel();
        if (barrel.overlaying) {
            if (barrel.sideUpgrades[side] == 3) {
                ret = text_sidehopper;
            } else if (barrel.sideUpgrades[side] == 4) {
                ret = text_siders;
            } else if (sideIsLabel) {
                if (ghosting && linked) {
                    ret = text_locklinked;
                } else if (ghosting) {
                    ret = text_lock;
                } else if (linked) {
                    ret = text_linked;
                }
            }
        } else {
            ret = (side == 0 || side == 1) && sideIsLabel ? StructuralLevel.LEVELS[levelStructural].clientData.getIconLabelTop() : ((side == 0 || side == 1) && !sideIsLabel ? StructuralLevel.LEVELS[levelStructural].clientData.getIconTop() : (sideIsLabel ? StructuralLevel.LEVELS[levelStructural].clientData.getIconLabel() : StructuralLevel.LEVELS[levelStructural].clientData.getIconSide()));
        }
        return side == 0 ? new IconFlipped(ret, true, false) : ret;
    }

    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return text_linked;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        boolean sideIsLabel;
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
        TileEntity te = Utils.getTileEntityPreferNotCreating(world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ);
        if (te == null || !(te instanceof TileEntityBarrel) || !((TileEntityBarrel)te).overlaying) {
            return super.func_149646_a(world, x, y, z, side);
        }
        TileEntityBarrel barrel = (TileEntityBarrel)te;
        boolean ghosting = barrel.getStorage().isGhosting();
        boolean linked = barrel.getLinked();
        boolean bl = sideIsLabel = barrel.sideUpgrades[side] == 1 || barrel.sideUpgrades[side] == 2;
        if (barrel.sideUpgrades[side] == 3) {
            return true;
        }
        if (barrel.sideUpgrades[side] == 4) {
            return true;
        }
        if (sideIsLabel) {
            return ghosting || linked;
        }
        return false;
    }
}

