/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.entities.ai;

import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.world.World;

public abstract class EntityAIMoveToBlock
extends EntityAIBase {
    private final EntityCreature theEntity;
    private final double movementSpeed;
    protected int runDelay;
    private int timeoutCounter;
    private int maxStayTicks;
    protected BlockPos destinationBlock = BlockPos.ORIGIN;
    private boolean isAboveDestination;
    private final int searchLength;

    public EntityAIMoveToBlock(EntityCreature creature, double speedIn, int length) {
        this.theEntity = creature;
        this.movementSpeed = speedIn;
        this.searchLength = length;
        this.func_75248_a(5);
    }

    public boolean func_75250_a() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = 200 + this.theEntity.func_70681_au().nextInt(200);
        return this.searchForDestination();
    }

    public boolean func_75253_b() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.shouldMoveTo(this.theEntity.field_70170_p, this.destinationBlock);
    }

    public void func_75249_e() {
        this.theEntity.func_70661_as().func_75492_a((double)this.destinationBlock.getX() + 0.5, (double)(this.destinationBlock.getY() + 1), (double)this.destinationBlock.getZ() + 0.5, this.movementSpeed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.theEntity.func_70681_au().nextInt(this.theEntity.func_70681_au().nextInt(1200) + 1200) + 1200;
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        if (this.theEntity.func_70092_e((double)this.destinationBlock.up().getX(), (double)this.destinationBlock.up().getY(), (double)this.destinationBlock.up().getZ()) > 1.0) {
            this.isAboveDestination = false;
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.theEntity.func_70661_as().func_75492_a((double)this.destinationBlock.getX() + 0.5, (double)(this.destinationBlock.getY() + 1), (double)this.destinationBlock.getZ() + 0.5, this.movementSpeed);
            }
        } else {
            this.isAboveDestination = true;
            --this.timeoutCounter;
        }
    }

    protected boolean getIsAboveDestination() {
        return this.isAboveDestination;
    }

    private boolean searchForDestination() {
        int i = this.searchLength;
        BlockPos blockpos = new BlockPos((Entity)this.theEntity);
        int j = 0;
        while (j <= 1) {
            for (int k = 0; k < i; ++k) {
                int l = 0;
                while (l <= k) {
                    int i1;
                    int n = i1 = l < k && l > -k ? k : 0;
                    while (i1 <= k) {
                        BlockPos blockpos1 = blockpos.add(l, j - 1, i1);
                        if (this.theEntity.func_110176_b(blockpos1.getX(), blockpos1.getY(), blockpos1.getZ()) && this.shouldMoveTo(this.theEntity.field_70170_p, blockpos1)) {
                            this.destinationBlock = blockpos1;
                            return true;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                    l = l > 0 ? -l : 1 - l;
                }
            }
            j = j > 0 ? -j : 1 - j;
        }
        return false;
    }

    protected abstract boolean shouldMoveTo(World var1, BlockPos var2);
}

