/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tileentity;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.apiculture.ApiaryBeeListener;
import forestry.apiculture.IApiary;
import forestry.apiculture.inventory.IApiaryInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import magicbees.api.bees.IMagicApiaryAuraProvider;
import magicbees.bees.AuraCharge;
import magicbees.bees.BeeManager;
import magicbees.bees.MagicApiaryInventory;
import magicbees.main.utils.ChunkCoords;
import magicbees.main.utils.net.EventAuraChargeUpdate;
import magicbees.main.utils.net.NetworkEventHandler;
import magicbees.tileentity.AuraCharges;
import magicbees.tileentity.ITileEntityAuraCharged;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class TileEntityMagicApiary
extends TileEntity
implements ISidedInventory,
IApiary,
ITileEntityAuraCharged {
    private static final int AURAPROVIDER_SEARCH_RADIUS = 6;
    public static final String tileEntityName = "magicbees.magicApiary";
    private GameProfile ownerProfile;
    private IMagicApiaryAuraProvider auraProvider;
    private ChunkCoords auraProviderPosition;
    private BiomeGenBase biome;
    private int breedingProgressPercent = 0;
    private final IBeekeepingLogic beeLogic = BeeManager.beeRoot.createBeekeepingLogic((IBeeHousing)this);
    private final IBeeListener beeListener = new ApiaryBeeListener((IApiary)this);
    private final IBeeModifier beeModifier = new MagicApiaryBeeModifier(this);
    private final MagicApiaryInventory inventory = new MagicApiaryInventory(this);
    private final IErrorLogic errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
    private final AuraCharges auraCharges = new AuraCharges();

    public Iterable<IBeeModifier> getBeeModifiers() {
        ArrayList<IBeeModifier> beeModifiers = new ArrayList<IBeeModifier>();
        beeModifiers.add(this.beeModifier);
        for (IHiveFrame frame : this.inventory.getFrames()) {
            beeModifiers.add(frame.getBeeModifier());
        }
        return beeModifiers;
    }

    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    public IApiaryInventory getApiaryInventory() {
        return this.inventory;
    }

    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    public GameProfile getOwner() {
        return this.ownerProfile;
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Vec3 getBeeFXCoordinates() {
        return Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
    }

    public BiomeGenBase getBiome() {
        if (this.biome == null) {
            this.biome = this.field_145850_b.getBiomeGenForCoordsBody(this.field_145851_c, this.field_145849_e);
        }
        return this.biome;
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome((BiomeGenBase)this.getBiome(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue((float)this.getExactHumidity());
    }

    public int getBlockLightValue() {
        return this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    public boolean canBlockSeeTheSky() {
        return this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    public int func_70302_i_() {
        return this.inventory.getSizeInventory();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.getStackInSlot(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= j) {
                this.func_70299_a(i, null);
            } else {
                itemStack = itemStack.func_77979_a(j);
                this.func_70296_d();
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack item = this.func_70301_a(i);
        this.func_70299_a(i, null);
        return item;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory.setInventorySlotContents(i, itemStack);
        this.func_70296_d();
    }

    public String func_145825_b() {
        return tileEntityName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.inventory.getInventoryStackLimit();
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.inventory.writeToNBT(compound);
        this.beeLogic.writeToNBT(compound);
        ChunkCoords.writeToNBT(this.auraProviderPosition, compound);
        this.auraCharges.writeToNBT(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.readFromNBT(compound);
        this.beeLogic.readFromNBT(compound);
        this.auraProviderPosition = ChunkCoords.readFromNBT(compound);
        this.auraCharges.readFromNBT(compound);
    }

    public Packet func_145844_m() {
        this.beeLogic.syncToClient();
        EventAuraChargeUpdate event = new EventAuraChargeUpdate(new ChunkCoords(this), this.auraCharges);
        return event.getPacket();
    }

    public float getExactHumidity() {
        return this.getBiome().field_76751_G;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.updateClientSide();
        } else {
            this.updateServerSide();
        }
    }

    public void updateClientSide() {
        if (this.beeLogic.canDoBeeFX() && this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.beeLogic.doBeeFX();
        }
    }

    public void updateServerSide() {
        if (this.auraProvider == null) {
            this.findAuraProvider();
        } else {
            this.updateAuraProvider();
        }
        this.tickCharges();
        if (this.beeLogic.canWork()) {
            this.beeLogic.doWork();
        }
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.breedingProgressPercent = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.beeLogic.getBeeProgressPercent());
    }

    public boolean isProductionBoosted() {
        return this.auraCharges.isActive(AuraCharge.PRODUCTION);
    }

    public boolean isDeathRateBoosted() {
        return this.auraCharges.isActive(AuraCharge.DEATH);
    }

    public boolean isMutationBoosted() {
        return this.auraCharges.isActive(AuraCharge.MUTATION);
    }

    private void updateAuraProvider() {
        if (this.field_145850_b.func_82737_E() % 10L != 0L) {
            return;
        }
        if (this.getAuraProvider(this.auraProviderPosition) == null) {
            this.auraProvider = null;
            this.auraProviderPosition = null;
            return;
        }
        boolean auraChargesChanged = false;
        for (AuraCharge charge : AuraCharge.values()) {
            if (this.auraCharges.isActive(charge) || !this.auraProvider.getCharge(charge.type)) continue;
            this.auraCharges.start(charge, this.field_145850_b);
            auraChargesChanged = true;
        }
        if (auraChargesChanged) {
            NetworkEventHandler.getInstance().sendAuraChargeUpdate(this, this.auraCharges);
        }
    }

    private void tickCharges() {
        boolean auraChargesChanged = false;
        for (AuraCharge charge : AuraCharge.values()) {
            if (!this.auraCharges.isActive(charge) || !this.auraCharges.isExpired(charge, this.field_145850_b) || this.auraProvider != null && this.auraProvider.getCharge(charge.type)) continue;
            this.auraCharges.stop(charge);
            auraChargesChanged = true;
        }
        if (auraChargesChanged) {
            NetworkEventHandler.getInstance().sendAuraChargeUpdate(this, this.auraCharges);
        }
    }

    private void findAuraProvider() {
        if (this.field_145850_b.func_82737_E() % 5L != 0L) {
            return;
        }
        if (this.auraProviderPosition == null) {
            List<Chunk> chunks = this.getChunksInSearchRange();
            for (Chunk chunk : chunks) {
                if (this.searchChunkForBooster(chunk)) break;
            }
        } else {
            this.auraProvider = this.getAuraProvider(this.auraProviderPosition);
            if (this.auraProvider == null) {
                this.auraProviderPosition = null;
            }
        }
    }

    private List<Chunk> getChunksInSearchRange() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(4);
        chunks.add(this.field_145850_b.func_72938_d(this.field_145851_c - 6, this.field_145849_e - 6));
        Chunk chunk = this.field_145850_b.func_72938_d(this.field_145851_c + 6, this.field_145849_e - 6);
        if (!chunks.contains(chunk)) {
            chunks.add(chunk);
        }
        if (!chunks.contains(chunk = this.field_145850_b.func_72938_d(this.field_145851_c - 6, this.field_145849_e + 6))) {
            chunks.add(chunk);
        }
        if (!chunks.contains(chunk = this.field_145850_b.func_72938_d(this.field_145851_c + 6, this.field_145849_e + 6))) {
            chunks.add(chunk);
        }
        return chunks;
    }

    private boolean searchChunkForBooster(Chunk chunk) {
        Vec3 apiaryPos = Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        for (Map.Entry entry : chunk.field_150816_i.entrySet()) {
            Vec3 tePos;
            Vec3 result;
            TileEntity entity = (TileEntity)entry.getValue();
            if (!(entity instanceof IMagicApiaryAuraProvider) || !((result = apiaryPos.func_72444_a(tePos = Vec3.func_72443_a((double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e))).func_72433_c() <= 6.0)) continue;
            this.saveAuraProviderPosition(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e);
            this.auraProvider = (IMagicApiaryAuraProvider)entity;
            return true;
        }
        return false;
    }

    private void saveAuraProviderPosition(int x, int y, int z) {
        this.auraProviderPosition = new ChunkCoords(this.field_145850_b.field_73011_w.field_76574_g, x, y, z);
    }

    private IMagicApiaryAuraProvider getAuraProvider(ChunkCoords coords) {
        return this.getAuraProvider(coords.x, coords.y, coords.z);
    }

    private IMagicApiaryAuraProvider getAuraProvider(int x, int y, int z) {
        ChunkPosition cPos;
        TileEntity entity;
        Chunk chunk = this.field_145850_b.func_72938_d(x, z);
        z %= 16;
        if ((x %= 16) < 0) {
            x += 16;
        }
        if (z < 0) {
            z += 16;
        }
        if (!((entity = (TileEntity)chunk.field_150816_i.get(cPos = new ChunkPosition(x, y, z))) instanceof IMagicApiaryAuraProvider)) {
            return null;
        }
        return (IMagicApiaryAuraProvider)entity;
    }

    @Override
    public AuraCharges getAuraCharges() {
        return this.auraCharges;
    }

    public int[] func_94128_d(int i) {
        return this.inventory.getAccessibleSlotsFromSide(i);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int i1) {
        return this.inventory.canInsertItem(i, itemStack, i1);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int i1) {
        return this.inventory.canExtractItem(i, itemStack, i1);
    }

    private static class MagicApiaryBeeModifier
    extends DefaultBeeModifier {
        private final TileEntityMagicApiary magicApiary;

        public MagicApiaryBeeModifier(TileEntityMagicApiary magicApiary) {
            this.magicApiary = magicApiary;
        }

        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.magicApiary.isMutationBoosted() ? 2.0f : 1.0f;
        }

        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.magicApiary.isDeathRateBoosted() ? 2.0f : 1.0f;
        }

        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return this.magicApiary.isProductionBoosted() ? 0.8f : -0.1f;
        }

        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return 0.8f;
        }
    }
}

