/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.block;

import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizons.modularui.api.math.Color;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.multi.godforge.color.ForgeOfGodsStarColor;
import tectech.thing.metaTileEntity.multi.godforge.color.StarColorSetting;

public class TileEntityForgeOfGods
extends TileEntity {
    private float radius = 32.0f;
    private float rotationSpeed = 10.0f;
    private int ringCount = 1;
    private float rotAngle = 0.0f;
    private float rotAxisX = 1.0f;
    private float rotAxisY = 0.0f;
    private float rotAxisZ = 0.0f;
    private AxisAlignedBB renderBoundingBox;
    private ForgeOfGodsStarColor starColor = ForgeOfGodsStarColor.DEFAULT;
    private int currentColor = Color.rgb((int)179, (int)204, (int)255);
    private float gamma = 3.0f;
    private long lastColorUpdateTime = 0L;
    private float cycleStep;
    private int interpIndex;
    private int interpA;
    private int interpB;
    private float interpGammaA;
    private float interpGammaB;
    private static final String NBT_TAG = "FOG:";
    private static final String ROTATION_SPEED_NBT_TAG = "FOG:ROTATION";
    private static final String SIZE_NBT_TAG = "FOG:RADIUS";
    private static final String RINGS_NBT_TAG = "FOG:RINGS";
    private static final String ROT_ANGLE_NBT_TAG = "FOG:ROT_ANGLE";
    private static final String ROT_AXIS_X_NBT_TAG = "FOG:ROT_AXIS_X";
    private static final String ROT_AXIS_Y_NBT_TAG = "FOG:ROT_AXIS_Y";
    private static final String ROT_AXIS_Z_NBT_TAG = "FOG:ROT_AXIS_Z";
    private static final String STAR_COLOR_TAG = "FOG:STAR_COLOR";
    public static final float BACK_PLATE_DISTANCE = -121.5f;
    public static final float BACK_PLATE_RADIUS = 13.0f;
    private static final double RING_RADIUS = 63.0;
    private static final double BEAM_LENGTH = 59.0;
    private static final float COLOR_CYCLE_SPEED = 16.0f;

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBoundingBox == null) {
            double x = this.field_145851_c;
            double y = this.field_145848_d;
            double z = this.field_145849_e;
            this.renderBoundingBox = AxisAlignedBB.func_72330_a((double)(x - 63.0 - 59.0), (double)(y - 63.0 - 59.0), (double)(z - 63.0 - 59.0), (double)(x + 63.0 + 59.0 + 1.0), (double)(y + 63.0 + 59.0 + 1.0), (double)(z + 63.0 + 59.0 + 1.0));
        }
        return this.renderBoundingBox;
    }

    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    public void setStarRadius(float size) {
        this.radius = size;
    }

    public float getStarRadius() {
        return this.radius;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setRotationSpeed(float speed) {
        this.rotationSpeed = speed;
    }

    public float getColorR() {
        return Color.getRedF((int)this.currentColor);
    }

    public float getColorG() {
        return Color.getGreenF((int)this.currentColor);
    }

    public float getColorB() {
        return Color.getBlueF((int)this.currentColor);
    }

    public float getGamma() {
        return this.gamma;
    }

    public void setColor(ForgeOfGodsStarColor color) {
        this.starColor = color;
        if (this.starColor == null) {
            this.starColor = ForgeOfGodsStarColor.DEFAULT;
        }
        StarColorSetting colorSetting = this.starColor.getColor(0);
        this.currentColor = Color.rgb((int)colorSetting.getColorR(), (int)colorSetting.getColorG(), (int)colorSetting.getColorB());
        this.gamma = colorSetting.getGamma();
        if (this.starColor.numColors() > 1) {
            this.cycleStep = 0.0f;
            this.interpA = this.currentColor;
            this.interpGammaA = this.gamma;
            colorSetting = this.starColor.getColor(1);
            this.interpB = Color.rgb((int)colorSetting.getColorR(), (int)colorSetting.getColorG(), (int)colorSetting.getColorB());
            this.interpGammaB = colorSetting.getGamma();
        }
    }

    public int getRingCount() {
        return this.ringCount;
    }

    public void setRingCount(int count) {
        if (this.ringCount < 1) {
            return;
        }
        this.ringCount = count;
    }

    public float getRotAngle() {
        return this.rotAngle;
    }

    public float getRotAxisX() {
        return this.rotAxisX;
    }

    public float getRotAxisY() {
        return this.rotAxisY;
    }

    public float getRotAxisZ() {
        return this.rotAxisZ;
    }

    public void setRenderRotation(Rotation rotation, ForgeDirection direction) {
        switch (direction) {
            case SOUTH: 
            case NORTH: {
                this.rotAngle = 90.0f;
                break;
            }
            case WEST: {
                this.rotAngle = 0.0f;
                break;
            }
            case EAST: {
                this.rotAngle = 180.0f;
                break;
            }
            case UP: 
            case DOWN: {
                this.rotAngle = -90.0f;
            }
        }
        this.rotAxisX = 0.0f;
        this.rotAxisY = direction.offsetZ + direction.offsetX;
        this.rotAxisZ = direction.offsetY;
        this.updateToClient();
    }

    public float getLensDistance(int lensID) {
        float f;
        switch (lensID) {
            case 0: {
                f = -61.5f;
                break;
            }
            case 1: {
                f = -54.5f;
                break;
            }
            case 2: {
                f = -44.5f;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + lensID);
            }
        }
        return f;
    }

    public float getLenRadius(int lensID) {
        float f;
        switch (lensID) {
            case 0: {
                f = 1.1f;
                break;
            }
            case 1: {
                f = 3.5f;
                break;
            }
            case 2: {
                f = 5.0f;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + lensID);
            }
        }
        return f;
    }

    public float getStartAngle() {
        float x = -this.getLensDistance(this.getRingCount() - 1);
        float y = this.getLenRadius(this.getRingCount() - 1);
        float alpha = (float)Math.atan2(y, x);
        float beta = (float)Math.asin((double)this.radius / Math.sqrt(x * x + y * y));
        return alpha + (1.5707964f - beta);
    }

    public static float interpolate(float x0, float x1, float y0, float y1, float x) {
        return y0 + (x - x0) * (y1 - y0) / (x1 - x0);
    }

    public void incrementColors() {
        if (this.starColor.numColors() <= 1) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastColorUpdateTime == 0L) {
            this.lastColorUpdateTime = currentTime;
            return;
        }
        long deltaTime = currentTime - this.lastColorUpdateTime;
        this.lastColorUpdateTime = currentTime;
        float increment = (float)this.starColor.getCycleSpeed() * ((float)deltaTime / 16.0f);
        this.cycleStep += increment;
        while (this.cycleStep >= 255.0f) {
            this.cycleStep -= 255.0f;
            this.cycleStarColors();
            this.currentColor = this.interpA;
            this.gamma = this.interpGammaA;
        }
        this.interpolateColors();
    }

    private void interpolateColors() {
        float position = this.cycleStep / 255.0f;
        this.currentColor = Color.interpolate((int)this.interpA, (int)this.interpB, (double)position);
        this.gamma = this.interpGammaA + (this.interpGammaB - this.interpGammaA) * position;
    }

    private void cycleStarColors() {
        this.interpA = this.interpB;
        this.interpGammaA = this.interpGammaB;
        ++this.interpIndex;
        if (this.interpIndex >= this.starColor.numColors()) {
            this.interpIndex = 0;
        }
        StarColorSetting nextColor = this.starColor.getColor(this.interpIndex);
        this.interpB = Color.rgb((int)nextColor.getColorR(), (int)nextColor.getColorG(), (int)nextColor.getColorB());
        this.interpGammaB = nextColor.getGamma();
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74776_a(ROTATION_SPEED_NBT_TAG, this.rotationSpeed);
        compound.func_74776_a(SIZE_NBT_TAG, this.radius);
        compound.func_74768_a(RINGS_NBT_TAG, this.ringCount);
        compound.func_74776_a(ROT_ANGLE_NBT_TAG, this.rotAngle);
        compound.func_74776_a(ROT_AXIS_X_NBT_TAG, this.rotAxisX);
        compound.func_74776_a(ROT_AXIS_Y_NBT_TAG, this.rotAxisY);
        compound.func_74776_a(ROT_AXIS_Z_NBT_TAG, this.rotAxisZ);
        compound.func_74782_a(STAR_COLOR_TAG, (NBTBase)this.starColor.serializeToNBT());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.rotationSpeed = compound.func_74760_g(ROTATION_SPEED_NBT_TAG);
        this.radius = compound.func_74760_g(SIZE_NBT_TAG);
        this.ringCount = compound.func_74762_e(RINGS_NBT_TAG);
        if (this.ringCount < 1) {
            this.ringCount = 1;
        }
        this.rotAngle = compound.func_74760_g(ROT_ANGLE_NBT_TAG);
        this.rotAxisX = compound.func_74760_g(ROT_AXIS_X_NBT_TAG);
        this.rotAxisY = compound.func_74760_g(ROT_AXIS_Y_NBT_TAG);
        this.rotAxisZ = compound.func_74760_g(ROT_AXIS_Z_NBT_TAG);
        if (compound.func_74764_b(STAR_COLOR_TAG)) {
            this.setColor(ForgeOfGodsStarColor.deserialize(compound.func_74775_l(STAR_COLOR_TAG)));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void updateToClient() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

