/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.agrichem;

import gtPlusPlus.plugin.agrichem.AlgaeUtils;

public enum AlgaeDefinition {
    Euglenophyta("Euglenophyta", "Euglenoids", true, false, AlgaeDefinition.getRGB(147, 168, 50)),
    Chrysophyta("Chrysophyta", "Golden-Brown Algae", true, true, AlgaeDefinition.getRGB(186, 146, 0)),
    Pyrrophyta("Pyrrophyta", "Fire Algae", true, true, AlgaeDefinition.getRGB(250, 118, 2)),
    Chlorophyta("Chlorophyta", "Green Algae", true, true, AlgaeDefinition.getRGB(99, 181, 62)),
    Rhodophyta("Rhodophyta", "Red Algae", false, true, AlgaeDefinition.getRGB(153, 5, 22)),
    Paeophyta("Paeophyta", "Brown Algae", false, true, AlgaeDefinition.getRGB(94, 78, 47)),
    Xanthophyta("Xanthophyta", "Yellow-Green Algae", true, false, AlgaeDefinition.getRGB(118, 138, 16));

    public final String mScientificName;
    public final String mSimpleName;
    public final boolean mSaltWater;
    public final boolean mFreshWater;
    public final int mColour;

    private AlgaeDefinition(String aScientificName, String aSimpleName, boolean aFresh, boolean aSalt, int aColour) {
        this.mScientificName = aScientificName;
        this.mSimpleName = aSimpleName;
        this.mFreshWater = aFresh;
        this.mSaltWater = aSalt;
        this.mColour = aColour;
    }

    public static AlgaeDefinition getByIndex(int aIndex) {
        AlgaeDefinition algaeDefinition;
        switch (aIndex) {
            default: {
                algaeDefinition = Euglenophyta;
                break;
            }
            case 1: {
                algaeDefinition = Chrysophyta;
                break;
            }
            case 2: {
                algaeDefinition = Pyrrophyta;
                break;
            }
            case 3: {
                algaeDefinition = Chlorophyta;
                break;
            }
            case 4: {
                algaeDefinition = Rhodophyta;
                break;
            }
            case 5: {
                algaeDefinition = Paeophyta;
                break;
            }
            case 6: {
                algaeDefinition = Xanthophyta;
            }
        }
        return algaeDefinition;
    }

    private static int getRGB(int r, int g, int b) {
        return AlgaeUtils.rgbtoHexValue(r, g, b);
    }
}

