/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicBatteryBuffer;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;

public class MTECharger
extends MTEBasicBatteryBuffer {
    public MTECharger(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aDescription, aSlotCount);
    }

    public MTECharger(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTECharger(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mInventory.length);
    }

    @Override
    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier] * 64L * (long)this.mInventory.length;
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * 256L * (long)this.mInventory.length;
    }

    @Override
    public long maxAmperesIn() {
        return Math.max((long)this.mChargeableCount * 8L, 4L);
    }

    @Override
    public long maxAmperesOut() {
        return Math.max((long)this.mBatteryCount * 4L, 2L);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            BaseMetaTileEntity mBaseMetaTileEntity;
            IMetaTileEntity iMetaTileEntity;
            super.onPostTick(aBaseMetaTileEntity, aTick);
            if (this.getBaseMetaTileEntity() instanceof BaseMetaTileEntity && (iMetaTileEntity = (mBaseMetaTileEntity = (BaseMetaTileEntity)this.getBaseMetaTileEntity()).getMetaTileEntity()) instanceof MetaTileEntity) {
                int k;
                MetaTileEntity mMetaTileEntity = (MetaTileEntity)iMetaTileEntity;
                if (mMetaTileEntity.dechargerSlotCount() > 0 && mBaseMetaTileEntity.getStoredEU() < mBaseMetaTileEntity.getEUCapacity()) {
                    int i;
                    k = mMetaTileEntity.dechargerSlotCount() + i;
                    for (i = mMetaTileEntity.dechargerSlotStartIndex(); i < k; ++i) {
                        if (mMetaTileEntity.mInventory[i] == null || mBaseMetaTileEntity.getStoredEU() >= mBaseMetaTileEntity.getEUCapacity()) continue;
                        mBaseMetaTileEntity.increaseStoredEnergyUnits(GTModHandler.dischargeElectricItem(mMetaTileEntity.mInventory[i], GTUtility.safeInt(Math.min(GTValues.V[this.mTier] * 15L, mBaseMetaTileEntity.getEUCapacity() - mBaseMetaTileEntity.getStoredEU())), (int)Math.min(Integer.MAX_VALUE, mMetaTileEntity.getInputTier()), true, false, false), true);
                        if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                        mMetaTileEntity.mInventory[i] = null;
                    }
                }
                if (mMetaTileEntity.rechargerSlotCount() > 0 && mBaseMetaTileEntity.getStoredEU() > 0L) {
                    int i;
                    k = mMetaTileEntity.rechargerSlotCount() + i;
                    for (i = mMetaTileEntity.rechargerSlotStartIndex(); i < k; ++i) {
                        if (mBaseMetaTileEntity.getStoredEU() <= 0L || mMetaTileEntity.mInventory[i] == null) continue;
                        mBaseMetaTileEntity.decreaseStoredEU(GTModHandler.chargeElectricItem(mMetaTileEntity.mInventory[i], GTUtility.safeInt(Math.min(GTValues.V[this.mTier] * 15L, mBaseMetaTileEntity.getStoredEU())), (int)Math.min(Integer.MAX_VALUE, mMetaTileEntity.getOutputTier()), true, false), true);
                        if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                        mMetaTileEntity.mInventory[i] = null;
                    }
                }
            }
        }
    }
}

