/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.mui1.cover;

import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.covers.Cover;
import gregtech.common.covers.redstone.CoverWirelessItemDetector;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gregtech.common.gui.modularui.widget.ItemWatcherSlotWidget;
import gregtech.common.gui.mui1.cover.AdvancedRedstoneTransmitterBaseUIFactory;
import gregtech.common.tileentities.storage.MTEDigitalChestBase;
import java.text.FieldPosition;
import java.text.NumberFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class WirelessItemDetectorUIFactory
extends AdvancedRedstoneTransmitterBaseUIFactory<CoverWirelessItemDetector> {
    private int maxSlot;
    private int maxThreshold;
    private static final NumberFormatMUI numberFormatAll = new NumberFormatMUI(){

        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            if (number < 0.0) {
                return toAppendTo.append(StatCollector.func_74838_a((String)"gt.interact.desc.Item_Item_Detector.All"));
            }
            return super.format(number, toAppendTo, pos);
        }
    };

    public WirelessItemDetectorUIFactory(CoverUIBuildContext buildContext) {
        super(buildContext);
    }

    @Override
    protected int getGUIHeight() {
        return 143;
    }

    @Override
    protected CoverWirelessItemDetector adaptCover(Cover cover) {
        if (cover instanceof CoverWirelessItemDetector) {
            CoverWirelessItemDetector adaptedCover = (CoverWirelessItemDetector)cover;
            return adaptedCover;
        }
        return null;
    }

    @Override
    @NotNull
    protected CoverDataControllerWidget<CoverWirelessItemDetector> getDataController() {
        return new CoverDataControllerWidget<CoverWirelessItemDetector>(this::getCover, this.getUIBuildContext());
    }

    @Override
    protected void addUIWidgets(ModularWindow.Builder builder) {
        this.setMaxSlot();
        this.setMaxThreshold();
        super.addUIWidgets(builder);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ItemWatcherSlotWidget().setGetter(this::getTargetItem).setPos(81, 79))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.Item_Item_Detector.ItemThreshold")).setPos(100, 65))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.Item_Item_Detector.DetectSlot")).setPos(100, 83))).widget(TextWidget.dynamicString(this.getCoverString(c -> c.isPhysical() ? StatCollector.func_74838_a((String)"gt.cover.wirelessdetector.redstone.1") : StatCollector.func_74838_a((String)"gt.cover.wirelessdetector.redstone.0"))).setSynced(false).setTextAlignment(Alignment.CenterLeft).setPos(28, 102).setSize(180, 12));
    }

    @Override
    protected void addUIForDataController(CoverDataControllerWidget<CoverWirelessItemDetector> controller) {
        super.addUIForDataController(controller);
        controller.addFollower(new CoverDataFollowerNumericWidget(), coverData -> coverData.getThreshold(), (coverData, state) -> coverData.setThresdhold(state.intValue()), widget -> widget.setBounds(0.0, this.maxThreshold).setScrollValues(1.0, 64.0, 1000.0).setFocusOnGuiOpen(true).setPos(1, 38).setSize(86, 12)).addFollower(new CoverDataFollowerNumericWidget(), coverData -> coverData.getSlot(), (coverData, state) -> coverData.setSlot(state.intValue()), widget -> widget.setBounds(-1.0, this.maxSlot).setDefaultValue(-1.0).setScrollValues(1.0, 100.0, 10.0).setNumberFormat((NumberFormat)numberFormatAll).setPos(1, 56).setSize(64, 12)).addFollower(CoverDataFollowerToggleButtonWidget.ofDisableable(), CoverWirelessItemDetector::isPhysical, CoverWirelessItemDetector::setPhysical, widget -> widget.addTooltip(StatCollector.func_74838_a((String)"gt.cover.wirelessdetector.redstone.tooltip")).setPos(0, 74));
    }

    private void setMaxSlot() {
        IGregTechTileEntity gtTile;
        ICoverable tile = this.getUIBuildContext().getTile();
        this.maxSlot = !tile.isDead() && tile instanceof IGregTechTileEntity && !((gtTile = (IGregTechTileEntity)tile).getMetaTileEntity() instanceof MTEDigitalChestBase) ? tile.func_70302_i_() - 1 : -1;
    }

    private void setMaxThreshold() {
        IGregTechTileEntity gtTile;
        ICoverable tile = this.getUIBuildContext().getTile();
        this.maxThreshold = !tile.isDead() && tile instanceof IGregTechTileEntity && (gtTile = (IGregTechTileEntity)tile).getMetaTileEntity() instanceof MTEDigitalChestBase ? gtTile.getMaxItemCount() : (this.maxSlot > 0 ? this.maxSlot * 64 : Integer.MAX_VALUE);
    }

    private ItemStack getTargetItem() {
        ICoverable tile = this.getUIBuildContext().getTile();
        CoverWirelessItemDetector cover = (CoverWirelessItemDetector)this.getCover();
        if (cover != null && cover.getSlot() >= 0 && tile instanceof TileEntity && !tile.isDead() && tile.func_70302_i_() >= cover.getSlot()) {
            return tile.func_70301_a(cover.getSlot());
        }
        return null;
    }
}

