/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import gregtech.api.GregTechAPI;
import gregtech.api.objects.GTItemStack;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackendProperties;
import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTStreamUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecipeMapBackend {
    private RecipeMap<?> recipeMap;
    private final SetMultimap<GTItemStack, GTRecipe> itemIndex = LinkedHashMultimap.create();
    private final SetMultimap<String, GTRecipe> fluidIndex = LinkedHashMultimap.create();
    private final Map<RecipeCategory, Collection<GTRecipe>> recipesByCategory = new HashMap<RecipeCategory, Collection<GTRecipe>>();
    private final Int2ObjectLinkedOpenHashMap<GTRecipe> cacheMap = new Int2ObjectLinkedOpenHashMap();
    protected final RecipeMapBackendProperties properties;

    public RecipeMapBackend(RecipeMapBackendPropertiesBuilder propertiesBuilder) {
        this.properties = propertiesBuilder.build();
        GregTechAPI.itemStackMultiMaps.add(this.itemIndex);
    }

    void setRecipeMap(RecipeMap<?> recipeMap) {
        this.recipeMap = recipeMap;
    }

    public RecipeMapBackendProperties getProperties() {
        return this.properties;
    }

    public @Unmodifiable Collection<GTRecipe> getAllRecipes() {
        return Collections.unmodifiableCollection(this.allRecipes());
    }

    private Collection<GTRecipe> allRecipes() {
        return this.recipesByCategory.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
    }

    public @Unmodifiable Collection<GTRecipe> getRecipesByCategory(RecipeCategory recipeCategory) {
        return Collections.unmodifiableCollection(this.recipesByCategory.getOrDefault(recipeCategory, Collections.emptyList()));
    }

    public @Unmodifiable Map<RecipeCategory, Collection<GTRecipe>> getRecipeCategoryMap() {
        return Collections.unmodifiableMap(this.recipesByCategory);
    }

    public GTRecipe compileRecipe(GTRecipe recipe) {
        if (recipe.getRecipeCategory() == null) {
            recipe.setRecipeCategory(this.recipeMap.getDefaultRecipeCategory());
        }
        this.recipesByCategory.computeIfAbsent(recipe.getRecipeCategory(), v -> new ArrayList()).add(recipe);
        for (FluidStack fluid : recipe.mFluidInputs) {
            if (fluid == null) continue;
            this.fluidIndex.put((Object)fluid.getFluid().getName(), (Object)recipe);
        }
        return this.addToItemMap(recipe);
    }

    protected GTRecipe addToItemMap(GTRecipe recipe) {
        for (ItemStack item : recipe.mInputs) {
            if (item == null) continue;
            this.itemIndex.put((Object)new GTItemStack(item), (Object)recipe);
        }
        if (recipe instanceof GTRecipe.GTRecipe_WithAlt) {
            GTRecipe.GTRecipe_WithAlt recipeWithAlt = (GTRecipe.GTRecipe_WithAlt)recipe;
            for (ItemStack[] itemStacks : recipeWithAlt.mOreDictAlt) {
                if (itemStacks == null) continue;
                for (ItemStack item : itemStacks) {
                    if (item == null) continue;
                    this.itemIndex.put((Object)new GTItemStack(item), (Object)recipe);
                }
            }
        }
        return recipe;
    }

    protected Collection<GTRecipe> doAdd(GTRecipeBuilder builder) {
        this.properties.transformBuilder(builder);
        Iterable<? extends GTRecipe> recipes = this.properties.recipeEmitter.apply(builder);
        ArrayList<GTRecipe> ret = new ArrayList<GTRecipe>();
        for (GTRecipe gTRecipe : recipes) {
            if (gTRecipe.mInputs.length < this.properties.minItemInputs) {
                GTRecipeBuilder.handleInvalidRecipeLowItems();
                return Collections.emptyList();
            }
            if (gTRecipe.mFluidInputs.length < this.properties.minFluidInputs) {
                GTRecipeBuilder.handleInvalidRecipeLowFluids();
                return Collections.emptyList();
            }
            this.properties.transformRecipe(gTRecipe);
            if (builder.isCheckForCollision() && GTRecipeBuilder.ENABLE_COLLISION_CHECK && this.checkCollision(gTRecipe)) {
                this.handleCollision(gTRecipe);
                continue;
            }
            if (gTRecipe.getRecipeCategory() != null && gTRecipe.getRecipeCategory().recipeMap != this.recipeMap) {
                GTRecipeBuilder.handleInvalidRecipe();
                continue;
            }
            ret.add(this.compileRecipe(gTRecipe));
        }
        return ret;
    }

    private void handleCollision(GTRecipe recipe) {
        StringBuilder errorInfo = new StringBuilder();
        boolean hasAnEntry = false;
        for (FluidStack fluidStack : recipe.mFluidInputs) {
            String s;
            if (fluidStack == null || (s = fluidStack.getLocalizedName()) == null) continue;
            if (hasAnEntry) {
                errorInfo.append("+").append(s);
            } else {
                errorInfo.append(s);
            }
            hasAnEntry = true;
        }
        for (FluidStack fluidStack : recipe.mInputs) {
            if (fluidStack == null) continue;
            String itemName = fluidStack.func_82833_r();
            if (hasAnEntry) {
                errorInfo.append("+").append(itemName);
            } else {
                errorInfo.append(itemName);
            }
            hasAnEntry = true;
        }
        GTRecipeBuilder.handleRecipeCollision(errorInfo.toString());
    }

    public void removeRecipes(Collection<? extends GTRecipe> recipesToRemove) {
        for (Collection<GTRecipe> recipes : this.recipesByCategory.values()) {
            recipes.removeAll(recipesToRemove);
        }
        for (Object key : new HashMap(this.itemIndex.asMap()).keySet()) {
            this.itemIndex.get(key).removeAll(recipesToRemove);
        }
        for (Object key : new HashMap(this.fluidIndex.asMap()).keySet()) {
            this.fluidIndex.get(key).removeAll(recipesToRemove);
        }
    }

    public void removeRecipe(GTRecipe recipe) {
        this.removeRecipes(Collections.singleton(recipe));
    }

    public void clearRecipes() {
        this.recipesByCategory.clear();
    }

    public void reInit() {
        this.itemIndex.clear();
        for (GTRecipe recipe : this.allRecipes()) {
            GTOreDictUnificator.setStackArray(true, true, recipe.mInputs);
            GTOreDictUnificator.setStackArray(true, true, recipe.mOutputs);
            this.addToItemMap(recipe);
        }
    }

    public boolean containsInput(ItemStack item) {
        return this.itemIndex.containsKey((Object)new GTItemStack(item)) || this.itemIndex.containsKey((Object)new GTItemStack(item, true));
    }

    public boolean containsInput(Fluid fluid) {
        return this.fluidIndex.containsKey((Object)fluid.getName());
    }

    boolean checkCollision(GTRecipe recipe) {
        return this.matchRecipeStream(recipe.mInputs, recipe.mFluidInputs, null, null, false, true, true).findAny().isPresent();
    }

    @Nullable
    protected GTRecipe overwriteFindRecipe(ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot, @Nullable GTRecipe cachedRecipe) {
        return null;
    }

    protected boolean doesOverwriteFindRecipe() {
        return false;
    }

    @Nullable
    protected GTRecipe modifyFoundRecipe(GTRecipe recipe, ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot) {
        return recipe;
    }

    @Nullable
    protected GTRecipe findFallback(ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot) {
        return null;
    }

    Stream<GTRecipe> matchRecipeStream(@Nullable ItemStack @NotNull [] rawItems, @Nullable FluidStack @NotNull [] fluids, @Nullable ItemStack specialSlot, @Nullable GTRecipe cachedRecipe, boolean notUnificated, boolean dontCheckStackSizes, boolean forCollisionCheck) {
        if (this.doesOverwriteFindRecipe()) {
            return GTStreamUtil.ofNullable(this.overwriteFindRecipe(rawItems, fluids, specialSlot, cachedRecipe));
        }
        if (this.recipesByCategory.isEmpty()) {
            return Stream.empty();
        }
        if (!forCollisionCheck) {
            int count;
            if (this.properties.minFluidInputs > 0) {
                count = 0;
                for (FluidStack fluidStack2 : fluids) {
                    if (fluidStack2 == null) continue;
                    ++count;
                }
                if (count < this.properties.minFluidInputs) {
                    return Stream.empty();
                }
            }
            if (this.properties.minItemInputs > 0) {
                count = 0;
                for (FluidStack fluidStack3 : rawItems) {
                    if (fluidStack3 == null) continue;
                    ++count;
                }
                if (count < this.properties.minItemInputs) {
                    return Stream.empty();
                }
            }
        }
        ItemStack[] items = notUnificated ? GTOreDictUnificator.getStackArray(true, rawItems) : rawItems;
        Stream[] streamArray = new Stream[5];
        streamArray[0] = GTStreamUtil.ofNullable(cachedRecipe).filter(recipe -> recipe.mCanBeBuffered).filter(recipe -> this.filterFindRecipe((GTRecipe)recipe, items, fluids, specialSlot, dontCheckStackSizes)).map(recipe -> this.modifyFoundRecipe((GTRecipe)recipe, items, fluids, specialSlot)).filter(Objects::nonNull);
        streamArray[1] = GTStreamUtil.ofSupplier(() -> (GTRecipe)this.cacheMap.get(this.hash(items, fluids))).filter(Objects::nonNull).filter(recipe -> this.filterFindRecipe((GTRecipe)recipe, items, fluids, specialSlot, dontCheckStackSizes)).map(recipe -> this.modifyFoundRecipe((GTRecipe)recipe, items, fluids, specialSlot)).filter(Objects::nonNull);
        streamArray[2] = GTStreamUtil.ofConditional(!this.itemIndex.isEmpty(), items).filter(Objects::nonNull).flatMap(item -> Stream.of(new GTItemStack((ItemStack)item), new GTItemStack((ItemStack)item, true))).map(arg_0 -> this.itemIndex.get(arg_0)).flatMap(Collection::stream).filter(recipe -> this.filterFindRecipe((GTRecipe)recipe, items, fluids, specialSlot, dontCheckStackSizes)).map(recipe -> this.modifyFoundRecipe((GTRecipe)recipe, items, fluids, specialSlot)).filter(Objects::nonNull);
        streamArray[3] = GTStreamUtil.ofConditional(this.properties.minItemInputs == 0, fluids).filter(Objects::nonNull).map(fluidStack -> this.fluidIndex.get((Object)fluidStack.getFluid().getName())).flatMap(Collection::stream).filter(recipe -> this.filterFindRecipe((GTRecipe)recipe, items, fluids, specialSlot, dontCheckStackSizes)).map(recipe -> this.modifyFoundRecipe((GTRecipe)recipe, items, fluids, specialSlot)).filter(Objects::nonNull);
        streamArray[4] = forCollisionCheck ? Stream.empty() : GTStreamUtil.ofSupplier(() -> this.findFallback(items, fluids, specialSlot)).filter(Objects::nonNull);
        return Stream.of(streamArray).flatMap(Function.identity());
    }

    protected void cache(@Nullable ItemStack @NotNull [] items, @Nullable FluidStack @NotNull [] fluids, @NotNull GTRecipe recipe) {
        this.cacheMap.putAndMoveToFirst(this.hash(items, fluids), (Object)recipe);
        while (this.cacheMap.size() > 1024) {
            this.cacheMap.removeLast();
        }
    }

    protected int hash(@Nullable ItemStack @NotNull [] items, @Nullable FluidStack @NotNull [] fluids) {
        ItemStack stack;
        int i;
        int hash = 0;
        for (i = 0; i < items.length; ++i) {
            stack = items[i];
            if (stack == null) continue;
            Item item = stack.func_77973_b();
            assert (item != null);
            hash += item.hashCode();
            if (!item.func_77614_k()) continue;
            hash += Items.field_151008_G.getDamage(stack);
        }
        for (i = 0; i < fluids.length; ++i) {
            stack = fluids[i];
            if (stack == null) continue;
            Fluid fluid = stack.getFluid();
            hash += fluid.hashCode();
        }
        return hash;
    }

    protected boolean filterFindRecipe(@NotNull GTRecipe recipe, @Nullable ItemStack @NotNull [] items, @Nullable FluidStack @NotNull [] fluids, @Nullable ItemStack specialSlot, boolean dontCheckStackSizes) {
        if (recipe.mEnabled && !recipe.mFakeRecipe && recipe.isRecipeInputEqual(false, dontCheckStackSizes, fluids, items)) {
            return !this.properties.specialSlotSensitive || GTUtility.areStacksEqualOrNull((ItemStack)recipe.mSpecialItems, specialSlot);
        }
        return false;
    }

    @FunctionalInterface
    public static interface BackendCreator<B extends RecipeMapBackend> {
        public B create(RecipeMapBackendPropertiesBuilder var1);
    }
}

