/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs;

import cofh.api.energy.IEnergyReceiver;
import gregtech.api.GregTechAPI;
import gregtech.api.graphs.GenerateNodeMap;
import gregtech.api.graphs.Node;
import gregtech.api.graphs.PowerNode;
import gregtech.api.graphs.consumers.ConsumerNode;
import gregtech.api.graphs.consumers.EmptyPowerConsumer;
import gregtech.api.graphs.consumers.NodeEnergyConnected;
import gregtech.api.graphs.consumers.NodeEnergyReceiver;
import gregtech.api.graphs.consumers.NodeEnergySink;
import gregtech.api.graphs.consumers.NodeGTBaseMetaTile;
import gregtech.api.graphs.paths.NodePath;
import gregtech.api.graphs.paths.PowerNodePath;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.metatileentity.implementations.MTECable;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class GenerateNodeMapPower
extends GenerateNodeMap {
    public GenerateNodeMapPower(BaseMetaPipeEntity aTileEntity) {
        this.generateNode(aTileEntity, null, 1, null, ForgeDirection.UNKNOWN, new ArrayList<ConsumerNode>(), new HashSet<Node>());
    }

    @Override
    protected boolean isPipe(TileEntity aTileEntity) {
        return super.isPipe(aTileEntity) && ((BaseMetaPipeEntity)aTileEntity).getMetaTileEntity() instanceof MTECable;
    }

    @Override
    protected boolean addConsumer(TileEntity aTileEntity, ForgeDirection side, int aNodeValue, ArrayList<ConsumerNode> aConsumers) {
        if (aTileEntity instanceof BaseMetaTileEntity) {
            BaseMetaTileEntity tBaseTileEntity = (BaseMetaTileEntity)aTileEntity;
            if (tBaseTileEntity.inputEnergyFrom(side, false)) {
                NodeGTBaseMetaTile tConsumerNode = new NodeGTBaseMetaTile(aNodeValue, tBaseTileEntity, side, aConsumers);
                aConsumers.add(tConsumerNode);
                return true;
            }
        } else if (aTileEntity instanceof IEnergyConnected) {
            IEnergyConnected tTileEntity = (IEnergyConnected)aTileEntity;
            if (tTileEntity.inputEnergyFrom(side, false)) {
                NodeEnergyConnected tConsumerNode = new NodeEnergyConnected(aNodeValue, tTileEntity, side, aConsumers);
                aConsumers.add(tConsumerNode);
                return true;
            }
        } else if (aTileEntity instanceof IEnergySink) {
            IEnergySink sink = (IEnergySink)aTileEntity;
            int dX = aTileEntity.field_145851_c + side.offsetX;
            int dY = aTileEntity.field_145848_d + side.offsetY;
            int dZ = aTileEntity.field_145849_e + side.offsetZ;
            boolean crossesChuncks = dX >> 4 != aTileEntity.field_145851_c >> 4 || dZ >> 4 != aTileEntity.field_145849_e >> 4;
            TileEntity tNextTo = null;
            if (!crossesChuncks || !aTileEntity.func_145831_w().func_72899_e(dX, dY, dZ)) {
                tNextTo = aTileEntity.func_145831_w().func_147438_o(dX, dY, dZ);
            }
            if (sink.acceptsEnergyFrom(tNextTo, side)) {
                NodeEnergySink tConsumerNode = new NodeEnergySink(aNodeValue, (IEnergySink)aTileEntity, side, aConsumers);
                aConsumers.add(tConsumerNode);
                return true;
            }
        } else if (GregTechAPI.mOutputRF && aTileEntity instanceof IEnergyReceiver) {
            IEnergyReceiver receiver = (IEnergyReceiver)aTileEntity;
            NodeEnergyReceiver tConsumerNode = new NodeEnergyReceiver(aNodeValue, receiver, side, aConsumers);
            aConsumers.add(tConsumerNode);
            return true;
        }
        return false;
    }

    @Override
    protected NodePath getNewPath(MetaPipeEntity[] aPipes) {
        return new PowerNodePath(aPipes);
    }

    @Override
    protected Node getEmptyNode(int aNodeValue, ForgeDirection side, TileEntity aTileEntity, ArrayList<ConsumerNode> aConsumers) {
        EmptyPowerConsumer tNode = new EmptyPowerConsumer(aNodeValue, aTileEntity, side, aConsumers);
        aConsumers.add(tNode);
        return tNode;
    }

    @Override
    protected Node getPipeNode(int aNodeValue, ForgeDirection side, TileEntity aTileEntity, ArrayList<ConsumerNode> aConsumers) {
        return new PowerNode(aNodeValue, aTileEntity, aConsumers);
    }
}

