/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.gui.controls;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import shedar.mods.ic2.nuclearcontrol.api.DisplaySettingHelper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.api.IPanelMultiCard;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.gui.GuiAdvancedInfoPanel;
import shedar.mods.ic2.nuclearcontrol.gui.controls.GuiToggleButton;
import shedar.mods.ic2.nuclearcontrol.gui.controls.SmallGuiButton;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAdvancedInfoPanel;
import shedar.mods.ic2.nuclearcontrol.utils.DataSorter;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;

public class GuiScrollableList
extends GuiScreen {
    static final int GUI_WIDTH = 173;
    static final int GUI_HEIGHT = 233;
    private static final int PADDING_LEFT = 6;
    private static final int PADDING_TOP = 6;
    private static final int PADDING_BOTTOM = 7;
    static final int PADDING_MIDDLE = 7;
    static final int PADDING_RIGHT = 7;
    static final int THUMB_WIDTH = 12;
    private static final int THUMB_HEIGHT = 32;
    static final int BUTTON_HEIGHT = 20;
    static final int BUTTON_WIDTH = 140;
    static final int FUNCTION_BUTTON_HEIGHT = 15;
    static final int FUNCTION_BUTTON_WIDTH = 49;
    static final int FUNCTION_BUTTON_PADDING = 7;
    private static final int LIST_HEIGHT = 197;
    private static final int VISIBLE_BUTTONS = 10;
    static final int TOGGLE_BUTTON_WIDTH = 20;
    private static final int SCROLL_SPEED = 1;
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("nuclearcontrol:textures/gui/GUIAdvancedInfoPanelLinesBackground.png");
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("nuclearcontrol:textures/gui/GUIAdvancedInfoPanelLinesButtons.png");
    private static final int HOVER_DELAY = 5;
    private int guiLeft = 0;
    private int guiTop = 0;
    private int guiRight = 0;
    private int guiBottom = 0;
    int internalLeft = 0;
    private int internalTop = 0;
    private int listRight = 0;
    private int scrollbarLeft = 0;
    private int scrollbarRight = 0;
    int internalBottom = 0;
    private List<GuiToggleButton> buttonListFull = new ArrayList<GuiToggleButton>();
    private List<GuiToggleButton> originalButtonList = new ArrayList<GuiToggleButton>();
    private List<GuiToggleButton> visibleButtonList = new ArrayList<GuiToggleButton>();
    private List<SmallGuiButton> functionButtons = new ArrayList<SmallGuiButton>();
    private final GuiAdvancedInfoPanel parentGui;
    private int scrollOffset = 0;
    private int thumbLocation = 0;
    private int scrollbarOffset = -1;
    private int hoverDelayLeft = 5;
    private int previouslyHoveredButton = -1;
    private GuiToggleButton draggedButton = null;
    private int originalIndex = -1;
    private final TileEntityAdvancedInfoPanel panel;
    private final ItemStack card;
    private final byte cardSlot;
    private boolean dataSorterChanged = false;
    private DataSorter newDataSorter = null;
    private DataSorter originalDataSorter = null;
    private DisplaySettingHelper originalDisplaySettingHelper = null;

    public GuiScrollableList(GuiAdvancedInfoPanel parentGui, TileEntityAdvancedInfoPanel panel, ItemStack card) {
        this.parentGui = parentGui;
        this.panel = panel;
        this.card = card;
        this.cardSlot = panel.getIndexOfCard(card);
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - 173) / 2;
        this.guiTop = (this.field_146295_m - 233) / 2;
        this.guiRight = (this.field_146294_l + 173) / 2;
        this.guiBottom = (this.field_146295_m + 233) / 2;
        this.internalLeft = this.guiLeft + 6 + 1;
        this.internalTop = this.guiTop + 6 + 1;
        this.internalBottom = this.guiBottom - 7;
        this.listRight = this.internalLeft + 140;
        this.scrollbarLeft = this.guiRight - 12 - 7;
        this.scrollbarRight = this.scrollbarLeft + 12;
        this.thumbLocation = this.internalTop;
        this.newDataSorter = this.panel.getDataSorter(this.cardSlot);
        this.originalDataSorter = new DataSorter(this.panel.getDataSorter(this.cardSlot).getArray());
        this.originalDisplaySettingHelper = new DisplaySettingHelper(this.panel.getNewDisplaySettingsForCardInSlot(this.cardSlot));
        this.buttonListFull.clear();
        this.field_146292_n.clear();
        this.visibleButtonList.clear();
        this.functionButtons.add(new SmallGuiButton(0, this.internalLeft + 1, this.internalBottom - 15, 49, 15, StatCollector.func_74838_a((String)"tile.blockAdvancedInfoPanel.Save"), this::onSave));
        this.functionButtons.add(new SmallGuiButton(1, this.internalLeft + 1 + 49 + 7, this.internalBottom - 15, 48, 15, StatCollector.func_74838_a((String)"tile.blockAdvancedInfoPanel.Reset"), this::onReset));
        this.functionButtons.add(new SmallGuiButton(2, this.internalLeft + 112, this.internalBottom - 15, 49, 15, StatCollector.func_74838_a((String)"tile.blockAdvancedInfoPanel.Cancel"), this::onCancel));
        IPanelDataSource source = (IPanelDataSource)this.card.func_77973_b();
        List<PanelSetting> settingsList = this.card.func_77973_b() instanceof IPanelMultiCard ? ((IPanelMultiCard)((Object)source)).getSettingsList(new CardWrapperImpl(this.card, 0)) : source.getSettingsList();
        for (int i = 0; i < settingsList.size(); ++i) {
            this.buttonListFull.add(new GuiToggleButton(i + 3, this.internalLeft + 1, 0, settingsList.get((int)i).title, settingsList.get(i), this.panel, this.cardSlot));
        }
        this.originalButtonList = new ArrayList<GuiToggleButton>(this.buttonListFull);
        this.panel.getDataSorter(this.cardSlot).sortList(this.buttonListFull);
        this.updateVisibleButtons();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 173, 233);
        this.func_73729_b(this.scrollbarLeft, this.thumbLocation, 173, 0, 12, 32);
        this.field_146297_k.func_110434_K().func_110577_a(BUTTON_TEXTURE);
        for (SmallGuiButton functionButton : this.functionButtons) {
            functionButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        GL11.glEnable((int)3089);
        this.setScissor(this.internalLeft, this.internalTop, 166, 197);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GL11.glDisable((int)3089);
        if (this.draggedButton != null) {
            this.draggedButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        } else {
            this.drawButtonTooltip(this.field_146297_k, mouseX, mouseY);
        }
    }

    private void drawButtonTooltip(Minecraft mc, int mouseX, int mouseY) {
        if (mouseX >= this.internalLeft + 20 && mouseY >= this.internalTop && mouseX < this.listRight && mouseY < this.internalTop + this.visibleButtonList.size() * 20) {
            int buttonIndex = (mouseY - this.internalTop) / 20 + this.scrollOffset;
            if (buttonIndex == this.previouslyHoveredButton) {
                GuiToggleButton button = this.buttonListFull.get(buttonIndex);
                if (this.hoverDelayLeft == 0) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(button.getFullTitle());
                    this.drawTooltip(mc, mouseX, mouseY, list);
                } else {
                    --this.hoverDelayLeft;
                }
            } else {
                this.hoverDelayLeft = 5;
                this.previouslyHoveredButton = buttonIndex;
            }
        } else {
            this.hoverDelayLeft = 5;
            this.previouslyHoveredButton = -1;
        }
    }

    private void drawTooltip(Minecraft mc, int mouseX, int mouseY, List<String> textLines) {
        this.drawHoveringText(textLines, mouseX, mouseY, mc.field_71466_p);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    private void updateVisibleButtons() {
        this.field_146292_n.removeAll(this.buttonListFull);
        this.visibleButtonList.clear();
        for (int i = this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.buttonListFull.size() - 10)); i < this.scrollOffset + 10 && i < this.buttonListFull.size(); ++i) {
            GuiToggleButton btn = this.buttonListFull.get(i);
            btn.field_146129_i = 6 + (i - this.scrollOffset) * 20 + this.guiTop;
            this.visibleButtonList.add(btn);
        }
        this.field_146292_n.addAll(this.visibleButtonList);
    }

    private void setScissor(int x, int y, int width, int height) {
        int scaleFactor = this.field_146297_k.field_71474_y.field_74335_Z;
        GL11.glScissor((int)(x * scaleFactor), (int)(this.field_146297_k.field_71440_d - (y + height) * scaleFactor), (int)(width * scaleFactor), (int)(height * scaleFactor));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && mouseX > this.internalLeft && mouseX < this.guiRight - 7) {
            if (mouseX > this.internalLeft + 20 && mouseX < this.listRight) {
                if (mouseY > this.internalTop && mouseY < this.internalBottom - 15) {
                    for (GuiToggleButton o : this.visibleButtonList) {
                        if (mouseY < o.field_146129_i || mouseY >= o.field_146129_i + 20) continue;
                        this.draggedButton = o;
                        this.originalIndex = this.buttonListFull.indexOf((Object)this.draggedButton);
                        o.dragOffsetY = mouseY - o.field_146129_i;
                        break;
                    }
                }
            } else if (mouseX > this.scrollbarLeft && mouseX < this.scrollbarRight && mouseY > this.internalTop && mouseY < this.internalBottom - 15 - 7 + 2) {
                this.scrollbarOffset = Math.max(0, Math.min(mouseY - this.thumbLocation, 32));
                this.moveScrollbar(mouseY);
            }
            if (mouseX > this.internalLeft && mouseX < this.internalLeft + 173 && mouseY > this.internalBottom - 15 && mouseY < this.internalBottom) {
                for (SmallGuiButton b : this.functionButtons) {
                    b.func_146116_c(this.field_146297_k, mouseX, mouseY);
                }
            }
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.draggedButton != null) {
            int adjustedY = mouseY - this.draggedButton.dragOffsetY;
            if (adjustedY < this.internalTop) {
                adjustedY = this.internalTop;
                this.scrollUp();
            } else if (adjustedY > this.internalBottom - 15 - 7 - 20) {
                adjustedY = this.internalBottom - 15 - 7 - 20;
                this.scrollDown();
            }
            this.draggedButton.setPosition(adjustedY);
        } else if (this.scrollbarOffset != -1) {
            this.moveScrollbar(mouseY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.draggedButton != null) {
            int newIndex = (mouseY - this.guiTop + 6) / 20 + this.scrollOffset - 1;
            newIndex = Math.max(0, Math.min(this.buttonListFull.size() - 1, newIndex));
            if (newIndex != this.originalIndex) {
                this.buttonListFull.remove(this.originalIndex);
                this.buttonListFull.add(newIndex, this.draggedButton);
            }
            this.draggedButton = null;
            this.updateVisibleButtons();
            this.newDataSorter.computeSortOrder(this.originalButtonList, this.buttonListFull);
            this.dataSorterChanged = true;
        } else if (this.scrollbarOffset != -1) {
            this.moveScrollbar(mouseY);
            this.scrollbarOffset = -1;
        }
    }

    private void moveScrollbar(int mouseY) {
        int adjustedY;
        this.thumbLocation = adjustedY = mouseY - this.scrollbarOffset;
        if (adjustedY < this.internalTop) {
            this.thumbLocation = this.internalTop;
        } else if (adjustedY > this.internalBottom - 32 - 7 - 15) {
            this.thumbLocation = this.internalBottom - 32 - 7 - 15;
        }
        double offsetRatio = (double)(this.thumbLocation - this.internalTop) / (double)(this.internalBottom - this.internalTop - 32 - 7 - 15);
        int newScrollOffset = (int)(offsetRatio * (double)(this.buttonListFull.size() - 10));
        this.scrollOffset = Math.max(0, Math.min(newScrollOffset, this.buttonListFull.size() - 10));
        this.updateVisibleButtons();
    }

    private void updateThumbLocation() {
        double locationRatio = (double)this.scrollOffset / (double)(this.buttonListFull.size() - 10);
        int newThumbLocation = (int)(locationRatio * 165.0 + (double)this.internalTop);
        if (newThumbLocation < this.internalTop + 1) {
            newThumbLocation = this.internalTop;
        } else if (newThumbLocation > this.internalBottom - 32 - 7 - 15) {
            newThumbLocation = this.internalBottom - 32 - 7 - 15;
        }
        this.thumbLocation = newThumbLocation;
        this.updateVisibleButtons();
    }

    public void func_146274_d() {
        super.func_146274_d();
        int scroll = Mouse.getDWheel();
        if (scroll > 0) {
            this.scrollUp();
        } else if (scroll < 0) {
            this.scrollDown();
        }
    }

    private void scrollUp() {
        if (this.scrollOffset > 0) {
            --this.scrollOffset;
            this.updateThumbLocation();
        }
    }

    private void scrollDown() {
        if (this.scrollOffset + 10 < this.buttonListFull.size()) {
            ++this.scrollOffset;
            this.updateThumbLocation();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)this.parentGui);
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.dataSorterChanged) {
            NuclearNetworkHelper.sendDataSorterSync(this.panel);
        }
    }

    private void onReset() {
        this.panel.setDataSorter(this.cardSlot, new DataSorter(), false);
        this.dataSorterChanged = true;
        this.panel.setDisplaySettings(this.cardSlot, new DisplaySettingHelper());
        this.buttonListFull = new ArrayList<GuiToggleButton>(this.originalButtonList);
        this.updateVisibleButtons();
    }

    private void onSave() {
        if (this.dataSorterChanged) {
            NuclearNetworkHelper.sendDataSorterSync(this.panel);
        }
        this.field_146297_k.func_147108_a((GuiScreen)this.parentGui);
    }

    private void onCancel() {
        this.panel.setDataSorter(this.cardSlot, this.originalDataSorter, true);
        this.panel.setDisplaySettings(this.cardSlot, this.originalDisplaySettingHelper);
        this.field_146297_k.func_147108_a((GuiScreen)this.parentGui);
    }
}

