/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.math;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.misc.EmptyTeleporter;

public class TeleporterDimPos {
    public final double posX;
    public final double posY;
    public final double posZ;
    public final int dim;

    public static TeleporterDimPos of(double x, double y, double z, int dim) {
        return new TeleporterDimPos(x, y, z, dim);
    }

    public static TeleporterDimPos of(Entity entity) {
        return new TeleporterDimPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_71093_bK);
    }

    public static TeleporterDimPos of(int posx, int posy, int posz, int dim) {
        return new TeleporterDimPos((double)posx + 0.5, (double)posy + 0.1, (double)posz + 0.5, dim);
    }

    private TeleporterDimPos(double x, double y, double z, int d) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dim = d;
    }

    public BlockDimPos block() {
        return new BlockDimPos(this.posX, this.posY, this.posZ, this.dim);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void placeEntity(World world, Entity entity, float yaw) {
        entity.field_70179_y = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70159_w = 0.0;
        entity.field_70143_R = 0.0f;
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)entity;
            if (playerMP.field_71135_a != null) {
                playerMP.field_71135_a.func_147364_a(this.posX, this.posY, this.posZ, yaw, entity.field_70125_A);
                return;
            }
        }
        entity.func_70012_b(this.posX, this.posY, this.posZ, yaw, entity.field_70125_A);
    }

    @Nullable
    public Entity teleport(@Nullable Entity entity) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        if (ServerUtilitiesConfig.debugging.log_teleport) {
            ServerUtilities.LOGGER.info("Teleporting '" + entity.func_70005_c_() + "' to [" + this.posX + ',' + this.posY + ',' + this.posZ + "] in " + ServerUtils.getDimensionName(this.dim).func_150260_c());
        }
        if (this.dim != entity.field_71093_bK) {
            MinecraftServer server = ServerUtils.getServer();
            WorldServer currentDim = server.func_71218_a(entity.field_71093_bK);
            WorldServer newDim = server.func_71218_a(this.dim);
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)entity;
                server.func_71203_ab().transferPlayerToDimension(playerMP, this.dim, (Teleporter)new EmptyTeleporter(newDim, this));
                playerMP.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(playerMP.field_71106_cc, playerMP.field_71067_cb, playerMP.field_71068_ca));
                playerMP.func_71016_p();
                if (currentDim.field_73011_w.field_76574_g == 1 && playerMP.func_70089_S()) {
                    newDim.func_72838_d((Entity)playerMP);
                    newDim.func_72866_a((Entity)playerMP, false);
                }
            } else {
                server.func_71203_ab().transferEntityToWorld(entity, this.dim, currentDim, newDim, (Teleporter)new EmptyTeleporter(newDim, this));
            }
        }
        this.placeEntity(entity.field_70170_p, entity, entity.field_70177_z);
        return entity;
    }
}

