/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui.teams;

import net.minecraft.util.IChatComponent;
import serverutils.lib.EnumTeamColor;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.icon.Icon;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.util.FinalIDObject;

public class PublicTeamData
extends FinalIDObject
implements Comparable<PublicTeamData> {
    public static final DataOut.Serializer<PublicTeamData> SERIALIZER = (data, d) -> {
        data.writeString(d.getId());
        data.writeTextComponent(d.displayName);
        data.writeString(d.description);
        EnumTeamColor.NAME_MAP.write(data, d.color);
        data.writeIcon(d.icon);
        data.writeByte(d.type.ordinal());
    };
    public static final DataIn.Deserializer<PublicTeamData> DESERIALIZER = PublicTeamData::new;
    public final IChatComponent displayName;
    public final String description;
    public final EnumTeamColor color;
    public final Icon icon;
    public Type type;

    public PublicTeamData(DataIn data) {
        super(data.readString());
        this.displayName = data.readTextComponent();
        this.description = data.readString();
        this.color = EnumTeamColor.NAME_MAP.read(data);
        this.icon = data.readIcon();
        this.type = Type.values()[data.readUnsignedByte()];
    }

    public PublicTeamData(ForgeTeam team, Type c) {
        super(team.getId());
        this.displayName = team.getTitle();
        this.description = team.getDesc();
        this.color = team.getColor();
        this.icon = team.getIcon();
        this.type = c;
    }

    @Override
    public int compareTo(PublicTeamData o) {
        int i = this.type.compareTo(o.type);
        if (i == 0) {
            i = this.displayName.func_150260_c().compareToIgnoreCase(o.displayName.func_150260_c());
        }
        return i;
    }

    public static enum Type {
        CAN_JOIN,
        REQUESTING_INVITE,
        NEEDS_INVITE,
        ENEMY;

    }
}

