/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IPipe;
import buildcraft.transport.Gate;
import java.util.Iterator;
import net.minecraftforge.common.util.ForgeDirection;

public class ActionIterator
implements Iterable<StatementSlot> {
    private final IPipe pipe;

    public ActionIterator(IPipe iPipe) {
        this.pipe = iPipe;
    }

    @Override
    public Iterator<StatementSlot> iterator() {
        return new It();
    }

    private class It
    implements Iterator<StatementSlot> {
        private ForgeDirection curDir = ForgeDirection.values()[0];
        private int index = 0;
        private StatementSlot next;

        public It() {
            while (!this.isValid() && this.curDir != ForgeDirection.UNKNOWN) {
                if (ActionIterator.this.pipe.getGate(this.curDir) == null || this.index >= ActionIterator.this.pipe.getGate(this.curDir).getActiveActions().size() - 1) {
                    this.index = 0;
                    this.curDir = ForgeDirection.values()[this.curDir.ordinal() + 1];
                    continue;
                }
                ++this.index;
            }
            if (this.isValid()) {
                this.next = ActionIterator.this.pipe.getGate(this.curDir).getActiveActions().get(this.index);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public StatementSlot next() {
            StatementSlot result = this.next;
            do {
                if (this.index < Gate.MAX_STATEMENTS - 1) {
                    ++this.index;
                    continue;
                }
                if (this.curDir == ForgeDirection.UNKNOWN) break;
                this.index = 0;
                this.curDir = ForgeDirection.values()[this.curDir.ordinal() + 1];
            } while (!this.isValid());
            this.next = this.isValid() ? ActionIterator.this.pipe.getGate(this.curDir).getActiveActions().get(this.index) : null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported.");
        }

        private boolean isValid() {
            return this.curDir != ForgeDirection.UNKNOWN && ActionIterator.this.pipe.getGate(this.curDir) != null && this.index < ActionIterator.this.pipe.getGate(this.curDir).getActiveActions().size();
        }
    }
}

