/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftCore;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IFlexibleRecipeViewable;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.silicon.TileLaserTableBase;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fluids.FluidStack;

public class TileAssemblyTable
extends TileLaserTableBase
implements IInventory,
IFlexibleCrafter,
ICommandReceiver {
    public String currentRecipeId = "";
    public IFlexibleRecipe<ItemStack> currentRecipe;
    public HashMap<String, CraftingResult<ItemStack>> plannedOutputIcons = new HashMap();
    private HashSet<String> plannedOutput = new HashSet();
    private boolean queuedNetworkUpdate = false;

    public List<CraftingResult<ItemStack>> getPotentialOutputs() {
        LinkedList<CraftingResult<ItemStack>> result = new LinkedList<CraftingResult<ItemStack>>();
        for (IFlexibleRecipe<ItemStack> recipe : AssemblyRecipeManager.INSTANCE.getRecipes()) {
            CraftingResult<ItemStack> r = recipe.craft(this, true);
            if (r == null) continue;
            result.add(r);
        }
        return result;
    }

    private void queueNetworkUpdate() {
        this.queuedNetworkUpdate = true;
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.queuedNetworkUpdate) {
            this.sendNetworkUpdate();
            this.queuedNetworkUpdate = false;
        }
        if (this.currentRecipe == null) {
            return;
        }
        if (!this.currentRecipe.canBeCrafted(this)) {
            this.setNextCurrentRecipe();
            if (this.currentRecipe == null) {
                return;
            }
        }
        if (this.getEnergy() >= this.currentRecipe.craft((IFlexibleCrafter)this, (boolean)true).energyCost && this.currentRecipe.canBeCrafted(this)) {
            CraftingResult<ItemStack> result = this.currentRecipe.craft(this, false);
            this.setEnergy(Math.max(0, this.getEnergy() - result.energyCost));
            this.outputStack(((ItemStack)result.crafted).func_77946_l(), true);
            this.setNextCurrentRecipe();
        }
    }

    public int func_70302_i_() {
        return 12;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (this.currentRecipe == null) {
            this.setNextCurrentRecipe();
        }
    }

    public String func_145825_b() {
        return StringUtils.localize("tile.assemblyTableBlock.name");
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.currentRecipeId = NetworkUtils.readUTF(stream);
        this.plannedOutput.clear();
        int size = stream.readUnsignedByte();
        for (int i = 0; i < size; ++i) {
            this.plannedOutput.add(NetworkUtils.readUTF(stream));
        }
        this.generatePlannedOutputIcons();
        this.currentRecipe = AssemblyRecipeManager.INSTANCE.getRecipe(this.currentRecipeId);
    }

    private void generatePlannedOutputIcons() {
        for (String s : this.plannedOutput) {
            IFlexibleRecipe<ItemStack> recipe = AssemblyRecipeManager.INSTANCE.getRecipe(s);
            if (recipe != null) {
                Object out;
                CraftingResult<Object> result = recipe.craft(this, true);
                if (result != null && result.usedItems != null && result.usedItems.size() > 0) {
                    this.plannedOutputIcons.put(s, result);
                    continue;
                }
                if (!(recipe instanceof IFlexibleRecipeViewable) || !((out = ((IFlexibleRecipeViewable)((Object)recipe)).getOutput()) instanceof ItemStack)) continue;
                result = new CraftingResult();
                result.crafted = (ItemStack)out;
                result.recipe = recipe;
                this.plannedOutputIcons.put(s, result);
                continue;
            }
            this.plannedOutput.remove(s);
        }
        for (String s : this.plannedOutputIcons.keySet().toArray(new String[this.plannedOutputIcons.size()])) {
            if (this.plannedOutput.contains(s)) continue;
            this.plannedOutputIcons.remove(s);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        NetworkUtils.writeUTF(stream, this.currentRecipeId);
        stream.writeByte(this.plannedOutput.size());
        for (String s : this.plannedOutput) {
            NetworkUtils.writeUTF(stream, s);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        IFlexibleRecipe<ItemStack> recipe;
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("plannedIds", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            IFlexibleRecipe<ItemStack> recipe2 = AssemblyRecipeManager.INSTANCE.getRecipe(list.func_150307_f(i));
            if (recipe2 == null) continue;
            this.plannedOutput.add(recipe2.getId());
        }
        if (nbt.func_74764_b("recipeId") && (recipe = AssemblyRecipeManager.INSTANCE.getRecipe(nbt.func_74779_i("recipeId"))) != null) {
            this.setCurrentRecipe(recipe);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        for (String recipe : this.plannedOutput) {
            list.func_74742_a((NBTBase)new NBTTagString(recipe));
        }
        nbt.func_74782_a("plannedIds", (NBTBase)list);
        if (this.currentRecipe != null) {
            nbt.func_74778_a("recipeId", this.currentRecipe.getId());
        }
    }

    public boolean isPlanned(IFlexibleRecipe<ItemStack> recipe) {
        if (recipe == null) {
            return false;
        }
        return this.plannedOutput.contains(recipe.getId());
    }

    public boolean isAssembling(IFlexibleRecipe<ItemStack> recipe) {
        return recipe != null && recipe == this.currentRecipe;
    }

    private void setCurrentRecipe(IFlexibleRecipe<ItemStack> recipe) {
        this.currentRecipe = recipe;
        this.currentRecipeId = recipe != null ? recipe.getId() : "";
        this.generatePlannedOutputIcons();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.queueNetworkUpdate();
        }
    }

    @Override
    public int getRequiredEnergy() {
        if (this.currentRecipe != null) {
            CraftingResult<ItemStack> result = this.currentRecipe.craft(this, true);
            if (result != null) {
                return result.energyCost;
            }
            return 0;
        }
        return 0;
    }

    public void planOutput(IFlexibleRecipe<ItemStack> recipe) {
        if (recipe != null && !this.isPlanned(recipe)) {
            this.plannedOutput.add(recipe.getId());
            if (!this.isAssembling(this.currentRecipe) || !this.isPlanned(this.currentRecipe)) {
                this.setCurrentRecipe(recipe);
            }
            this.queueNetworkUpdate();
        }
    }

    public void cancelPlanOutput(IFlexibleRecipe<ItemStack> recipe) {
        if (this.isAssembling(recipe)) {
            this.setCurrentRecipe(null);
        }
        this.plannedOutput.remove(recipe.getId());
        if (!this.plannedOutput.isEmpty()) {
            this.setCurrentRecipe(AssemblyRecipeManager.INSTANCE.getRecipe(this.plannedOutput.iterator().next()));
        }
        this.queueNetworkUpdate();
    }

    public void setNextCurrentRecipe() {
        IFlexibleRecipe<ItemStack> recipe;
        boolean takeNext = false;
        for (String recipeId : this.plannedOutput) {
            recipe = AssemblyRecipeManager.INSTANCE.getRecipe(recipeId);
            if (recipe == null) continue;
            if (recipe == this.currentRecipe) {
                takeNext = true;
                continue;
            }
            if (!takeNext || !recipe.canBeCrafted(this)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        for (String recipeId : this.plannedOutput) {
            recipe = AssemblyRecipeManager.INSTANCE.getRecipe(recipeId);
            if (recipe == null || !recipe.canBeCrafted(this)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        this.setCurrentRecipe(null);
    }

    public void rpcSelectRecipe(final String id, final boolean select) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "select", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NetworkUtils.writeUTF(data, id);
                data.writeBoolean(select);
            }
        }));
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "select".equals(command)) {
            String id = NetworkUtils.readUTF(stream);
            boolean select = stream.readBoolean();
            IFlexibleRecipe<ItemStack> recipe = AssemblyRecipeManager.INSTANCE.getRecipe(id);
            if (recipe != null) {
                if (select) {
                    this.planOutput(recipe);
                } else {
                    this.cancelPlanOutput(recipe);
                }
            }
        }
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int getCraftingItemStackSize() {
        return this.func_70302_i_();
    }

    @Override
    public ItemStack getCraftingItemStack(int slotid) {
        return this.func_70301_a(slotid);
    }

    @Override
    public ItemStack decrCraftingItemStack(int slotid, int val) {
        return this.func_70298_a(slotid, val);
    }

    @Override
    public FluidStack getCraftingFluidStack(int tankid) {
        return null;
    }

    @Override
    public FluidStack decrCraftingFluidStack(int tankid, int val) {
        return null;
    }

    @Override
    public int getCraftingFluidStackSize() {
        return 0;
    }
}

