/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotStraightMoveTo;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotGotoStation
extends AIRobot {
    private BlockIndex stationIndex;
    private ForgeDirection stationSide;

    public AIRobotGotoStation(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoStation(EntityRobotBase iRobot, DockingStation station) {
        this(iRobot);
        this.stationIndex = station.index();
        this.stationSide = station.side();
        this.setSuccess(false);
    }

    @Override
    public void start() {
        DockingStation station = this.robot.getRegistry().getStation(this.stationIndex.x, this.stationIndex.y, this.stationIndex.z, this.stationSide);
        if (station == null) {
            this.terminate();
        } else if (station == this.robot.getDockingStation()) {
            this.setSuccess(true);
            this.terminate();
        } else if (station.take(this.robot)) {
            this.startDelegateAI(new AIRobotGotoBlock(this.robot, station.x() + station.side().offsetX, station.y() + station.side().offsetY, station.z() + station.side().offsetZ));
        } else {
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        DockingStation station = this.robot.getRegistry().getStation(this.stationIndex.x, this.stationIndex.y, this.stationIndex.z, this.stationSide);
        if (station == null) {
            this.terminate();
        } else if (ai instanceof AIRobotGotoBlock) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotStraightMoveTo(this.robot, (float)this.stationIndex.x + 0.5f + (float)this.stationSide.offsetX * 0.5f, (float)this.stationIndex.y + 0.5f + (float)this.stationSide.offsetY * 0.5f, (float)this.stationIndex.z + 0.5f + (float)this.stationSide.offsetZ * 0.5f));
            } else {
                this.terminate();
            }
        } else {
            this.setSuccess(true);
            if (this.stationSide.offsetY == 0) {
                this.robot.aimItemAt(this.stationIndex.x + 2 * this.stationSide.offsetX, this.stationIndex.y, this.stationIndex.z + 2 * this.stationSide.offsetZ);
            } else {
                this.robot.aimItemAt((float)MathHelper.func_76141_d((float)(this.robot.getAimYaw() / 90.0f)) * 90.0f + 180.0f, this.robot.getAimPitch());
            }
            this.robot.dock(station);
            this.terminate();
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.stationIndex.writeTo(indexNBT);
        nbt.func_74782_a("stationIndex", (NBTBase)indexNBT);
        nbt.func_74774_a("stationSide", (byte)this.stationSide.ordinal());
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        this.stationIndex = new BlockIndex(nbt.func_74775_l("stationIndex"));
        this.stationSide = ForgeDirection.values()[nbt.func_74771_c("stationSide")];
    }
}

