/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketCurrentItemNBT;
import mods.railcraft.common.util.network.PacketEffect;
import mods.railcraft.common.util.network.PacketGuiInteger;
import mods.railcraft.common.util.network.PacketGuiReturn;
import mods.railcraft.common.util.network.PacketGuiString;
import mods.railcraft.common.util.network.PacketGuiWidget;
import mods.railcraft.common.util.network.PacketKeyPress;
import mods.railcraft.common.util.network.PacketPairRequest;
import mods.railcraft.common.util.network.PacketPairUpdate;
import mods.railcraft.common.util.network.PacketTicketGui;
import mods.railcraft.common.util.network.PacketTileEntity;
import mods.railcraft.common.util.network.PacketTileExtraData;
import mods.railcraft.common.util.network.PacketTileRequest;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;

public class PacketHandler {
    public static final PacketHandler INSTANCE = new PacketHandler();
    private static final RailcraftPacket.PacketType[] packetTypes = RailcraftPacket.PacketType.values();
    final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("RC");

    private PacketHandler() {
        this.channel.register((Object)this);
    }

    public static void init() {
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        byte[] data = new byte[event.packet.payload().readableBytes()];
        event.packet.payload().readBytes(data);
        this.onPacketData(data, ((NetHandlerPlayServer)event.handler).field_147369_b);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        byte[] data = new byte[event.packet.payload().readableBytes()];
        event.packet.payload().readBytes(data);
        this.onPacketData(data, null);
    }

    public void onPacketData(byte[] bData, EntityPlayerMP player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bData));
        try {
            RailcraftPacket pkt;
            byte packetID = data.readByte();
            if (packetID < 0) {
                return;
            }
            RailcraftPacket.PacketType type = packetTypes[packetID];
            switch (type) {
                case TILE_ENTITY: {
                    pkt = new PacketTileEntity();
                    break;
                }
                case GUI_RETURN: {
                    pkt = new PacketGuiReturn((EntityPlayer)player);
                    break;
                }
                case TILE_EXTRA_DATA: {
                    pkt = new PacketTileExtraData();
                    break;
                }
                case TILE_REQUEST: {
                    pkt = new PacketTileRequest(player);
                    break;
                }
                case GUI_INTEGER: {
                    pkt = new PacketGuiInteger();
                    break;
                }
                case GUI_STRING: {
                    pkt = new PacketGuiString();
                    break;
                }
                case GUI_WIDGET: {
                    pkt = new PacketGuiWidget();
                    break;
                }
                case EFFECT: {
                    pkt = new PacketEffect();
                    break;
                }
                case CONTROLLER_UPDATE: 
                case RECEIVER_UPDATE: 
                case SIGNAL_UPDATE: {
                    pkt = new PacketPairUpdate(type);
                    break;
                }
                case CONTROLLER_REQUEST: 
                case RECEIVER_REQUEST: 
                case SIGNAL_REQUEST: {
                    pkt = new PacketPairRequest(player, type);
                    break;
                }
                case ITEM_NBT: {
                    pkt = new PacketCurrentItemNBT((EntityPlayer)player, player.func_71045_bC());
                    break;
                }
                case KEY_PRESS: {
                    pkt = new PacketKeyPress(player);
                    break;
                }
                case GOLDEN_TICKET_GUI: {
                    pkt = new PacketTicketGui();
                    break;
                }
                default: {
                    return;
                }
            }
            if (pkt != null) {
                pkt.readData(data);
            }
        }
        catch (IOException e) {
            Game.logThrowable("Exception in PacketHandler.onPacketData: {0}", e, Arrays.toString(bData));
        }
    }
}

