/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostBase;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostMetal;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.post.ItemPost;
import mods.railcraft.common.blocks.aesthetics.post.TilePostEmblem;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPost
extends BlockPostBase
implements IPostConnection {
    public static BlockPost block;

    protected BlockPost(int renderType) {
        super(renderType);
        this.func_149663_c("railcraft.post");
    }

    public static void registerBlock() {
        if (block != null) {
            return;
        }
        if (RailcraftConfig.isBlockEnabled("post")) {
            block = new BlockPost(Railcraft.getProxy().getRenderId());
            GameRegistry.registerTileEntity(TilePostEmblem.class, (String)"RCPostEmblemTile");
            RailcraftRegistry.register(block, ItemPost.class);
            for (EnumPost post : EnumPost.VALUES) {
                ItemStack stack = post.getItem();
                RailcraftRegistry.register(stack);
            }
            HarvestPlugin.setHarvestLevel(block, EnumPost.WOOD.ordinal(), "axe", 0);
            HarvestPlugin.setHarvestLevel(block, EnumPost.STONE.ordinal(), "pickaxe", 1);
            HarvestPlugin.setHarvestLevel(block, EnumPost.METAL_UNPAINTED.ordinal(), "pickaxe", 2);
            HarvestPlugin.setHarvestLevel(block, EnumPost.EMBLEM.ordinal(), "pickaxe", 2);
            HarvestPlugin.setHarvestLevel(block, EnumPost.WOOD_PLATFORM.ordinal(), "axe", 0);
            HarvestPlugin.setHarvestLevel(block, EnumPost.STONE_PLATFORM.ordinal(), "pickaxe", 1);
            HarvestPlugin.setHarvestLevel(block, EnumPost.METAL_PLATFORM_UNPAINTED.ordinal(), "pickaxe", 2);
            ForestryPlugin.addBackpackItem("builder", block);
        }
    }

    @Override
    public boolean isPlatform(int meta) {
        switch (EnumPost.fromId(meta)) {
            case WOOD_PLATFORM: 
            case STONE_PLATFORM: 
            case METAL_PLATFORM_UNPAINTED: {
                return true;
            }
        }
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumPost post : EnumPost.values()) {
            if (post == EnumPost.EMBLEM) continue;
            list.add(post.getItem());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IIcon woodIcon = iconRegister.func_94245_a("railcraft:post.wood");
        IIcon stoneIcon = iconRegister.func_94245_a("railcraft:concrete");
        IIcon metalIcon = iconRegister.func_94245_a("railcraft:post.metal");
        EnumPost.WOOD.setTexture(woodIcon);
        EnumPost.WOOD_PLATFORM.setTexture(woodIcon);
        EnumPost.STONE.setTexture(stoneIcon);
        EnumPost.STONE_PLATFORM.setTexture(stoneIcon);
        EnumPost.METAL_UNPAINTED.setTexture(metalIcon);
        EnumPost.METAL_PLATFORM_UNPAINTED.setTexture(metalIcon);
        EnumPost.EMBLEM.setTexture(metalIcon);
    }

    public IIcon func_149691_a(int side, int meta) {
        return EnumPost.fromId(meta).getIcon();
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TilePostEmblem post;
        EnumColor color;
        TileEntity tile;
        int meta = world.func_72805_g(x, y, z);
        if (meta == EnumPost.EMBLEM.ordinal() && (tile = world.func_147438_o(x, y, z)) instanceof TilePostEmblem && (color = (post = (TilePostEmblem)tile).getColor()) != null && BlockPostMetal.textures != null) {
            return BlockPostMetal.textures[color.ordinal()];
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    @Override
    public int func_149692_a(int meta) {
        return meta;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tile;
        if (metadata == EnumPost.EMBLEM.ordinal() && (tile = world.func_147438_o(x, y, z)) instanceof TilePostEmblem) {
            TilePostEmblem post = (TilePostEmblem)tile;
            ArrayList drops = super.getDrops(world, x, y, z, metadata, fortune);
            InvTools.setItemColor((ItemStack)drops.get(0), post.getColor());
            ItemPost.setEmblem((ItemStack)drops.get(0), post.getEmblem());
            return drops;
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        player.func_71064_a(StatList.field_75934_C[BlockPost.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        }
        return world.func_147468_f(x, y, z);
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == EnumPost.EMBLEM.ordinal()) {
            return false;
        }
        return side == ForgeDirection.DOWN || side == ForgeDirection.UP;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == EnumPost.EMBLEM.ordinal()) {
            return new TilePostEmblem();
        }
        return null;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == EnumPost.EMBLEM.ordinal();
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == EnumPost.WOOD.ordinal()) {
            return 300;
        }
        return 0;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == EnumPost.WOOD.ordinal()) {
            return 5;
        }
        return 0;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        int metadata = world.func_72805_g(x, y, z);
        return metadata == EnumPost.WOOD.ordinal();
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        TileEntity tile;
        int meta = world.func_72805_g(x, y, z);
        if (meta == EnumPost.METAL_UNPAINTED.ordinal() && BlockPostMetal.post != null) {
            world.func_147465_d(x, y, z, (Block)BlockPostMetal.post, 15 - colour, 3);
            return true;
        }
        if (meta == EnumPost.EMBLEM.ordinal() && (tile = world.func_147438_o(x, y, z)) instanceof TilePostEmblem) {
            TilePostEmblem tileEmblem = (TilePostEmblem)tile;
            tileEmblem.setColor(EnumColor.fromId(15 - colour));
            return true;
        }
        return false;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TilePostEmblem tileEmblem;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePostEmblem && (tileEmblem = (TilePostEmblem)tile).getFacing() == side) {
            return IPostConnection.ConnectStyle.NONE;
        }
        return IPostConnection.ConnectStyle.TWO_THIN;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile;
        super.func_149689_a(world, x, y, z, entity, stack);
        int meta = world.func_72805_g(x, y, z);
        if (meta == EnumPost.EMBLEM.ordinal() && (tile = world.func_147438_o(x, y, z)) instanceof TilePostEmblem) {
            TilePostEmblem post = (TilePostEmblem)tile;
            post.onBlockPlacedBy(entity, stack);
        }
    }
}

