/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.contents;

import appeng.api.config.PinsState;
import appeng.api.storage.ITerminalPins;
import appeng.items.contents.PinsHandler;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PinsHolder
implements IAEAppEngInventory {
    private final IAEAppEngInventory te;
    private final ItemStack is;
    private final HashMap<UUID, AppEngInternalAEInventory> pinsMap = new HashMap();
    private final HashMap<UUID, PinsState> pinsStateMap = new HashMap();
    private boolean initialized = false;

    public PinsHolder(ItemStack is) {
        this.is = is;
        this.te = null;
        this.readFromNBT(Platform.openNbtData(is), "pins");
        this.initialized = true;
    }

    public PinsHolder(ITerminalPins terminalPart) {
        IAEAppEngInventory _te;
        this.te = terminalPart instanceof IAEAppEngInventory ? (_te = (IAEAppEngInventory)((Object)terminalPart)) : null;
        this.is = null;
        this.initialized = true;
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagList c = new NBTTagList();
        for (Map.Entry<UUID, AppEngInternalAEInventory> entry : this.pinsMap.entrySet()) {
            UUID playerId = entry.getKey();
            AppEngInternalAEInventory pins = entry.getValue();
            NBTTagCompound itemList = new NBTTagCompound();
            itemList.func_74778_a("playerId", playerId.toString());
            int state = this.pinsStateMap.get(playerId) != null ? this.pinsStateMap.get(playerId).ordinal() : 0;
            itemList.func_74768_a("pinsState", state);
            for (int x = 0; x < pins.func_70302_i_(); ++x) {
                ItemStack pinStack = pins.func_70301_a(x);
                if (pinStack == null) continue;
                itemList.func_74782_a("#" + x, (NBTBase)pinStack.func_77955_b(new NBTTagCompound()));
            }
            c.func_74742_a((NBTBase)itemList);
        }
        data.func_74782_a(name, (NBTBase)c);
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        if (!data.func_74764_b(name)) {
            return;
        }
        NBTTagList list = data.func_150295_c(name, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemList = list.func_150305_b(i);
            String playerIdStr = itemList.func_74779_i("playerId");
            UUID playerId = UUID.fromString(playerIdStr);
            AppEngInternalAEInventory pins = new AppEngInternalAEInventory(this, PinsState.getPinsCount());
            for (int x = 0; x < PinsState.getPinsCount(); ++x) {
                if (!itemList.func_74764_b("#" + x)) continue;
                ItemStack pinStack = ItemStack.func_77949_a((NBTTagCompound)itemList.func_74775_l("#" + x));
                pins.func_70299_a(x, pinStack);
            }
            this.pinsMap.put(playerId, pins);
            this.pinsStateMap.put(playerId, PinsState.values()[itemList.func_74762_e("pinsState")]);
        }
    }

    public AppEngInternalAEInventory getPinsInv(EntityPlayer player) {
        AppEngInternalAEInventory pinsInv = this.pinsMap.get(player.getPersistentID());
        if (pinsInv == null) {
            pinsInv = new AppEngInternalAEInventory(this, PinsState.getPinsCount());
            this.pinsMap.put(player.getPersistentID(), pinsInv);
        }
        return pinsInv;
    }

    public PinsState getPinsState(EntityPlayer player) {
        return this.pinsStateMap.computeIfAbsent(player.getPersistentID(), k -> PinsState.DISABLED);
    }

    public void setPinsState(EntityPlayer player, PinsState state) {
        this.pinsStateMap.put(player.getPersistentID(), state);
        this.markDirty();
    }

    public void markDirty() {
        if (this.is == null || !this.initialized) {
            return;
        }
        this.writeToNBT(Platform.openNbtData(this.is), "pins");
    }

    @Override
    public void saveChanges() {
        this.markDirty();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.markDirty();
    }

    public PinsHandler getHandler(EntityPlayer player) {
        return new PinsHandler(this, player);
    }
}

