/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.draw.scroll;

import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.api.draw.Vector;
import com.github.dcysteine.neicustomdiagram.api.draw.scroll.ScrollDirection;

public enum ScrollOrientation {
    HORIZONTAL(1, 0),
    VERTICAL(0, 1);

    public final int xFactor;
    public final int yFactor;

    private ScrollOrientation(int xFactor, int yFactor) {
        this.xFactor = xFactor;
        this.yFactor = yFactor;
    }

    public Vector scale(int scale) {
        return Vector.create(this.xFactor * scale, this.yFactor * scale);
    }

    public Vector transposeScale(int scale) {
        return Vector.create(this.yFactor * scale, this.xFactor * scale);
    }

    public int dotProduct(ScrollDirection direction) {
        return this.xFactor * direction.xFactor + this.yFactor * direction.yFactor;
    }

    public int dotProduct(Point point) {
        return this.xFactor * point.x() + this.yFactor * point.y();
    }

    public int dotProduct(Vector vector) {
        return this.xFactor * vector.x() + this.yFactor * vector.y();
    }

    public int dotProduct(Dimension dimension) {
        return this.xFactor * dimension.width() + this.yFactor * dimension.height();
    }

    public int transposeProduct(Point point) {
        return this.yFactor * point.x() + this.xFactor * point.y();
    }

    public int transposeProduct(Vector vector) {
        return this.yFactor * vector.x() + this.xFactor * vector.y();
    }

    public int transposeProduct(Dimension dimension) {
        return this.yFactor * dimension.width() + this.xFactor * dimension.height();
    }
}

