/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.component;

import codechicken.nei.NEIClientUtils;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.$AutoValue_DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.FluidComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TextFormatting;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.toprettystring.ToPrettyString;
import com.google.common.base.Splitter;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

@AutoValue
public abstract class DisplayComponent
implements Comparable<DisplayComponent> {
    public static final Comparator<DisplayComponent> COMPARATOR = Comparator.comparing(DisplayComponent::component).thenComparing(d -> d.stackSize().orElse(-1));
    private static final Splitter NBT_SPLITTER = Splitter.fixedLength((int)64);

    public abstract Component component();

    public abstract Optional<Integer> stackSize();

    public abstract Optional<String> additionalInfo();

    public abstract Tooltip additionalTooltip();

    public Component.ComponentType type() {
        return this.component().type();
    }

    public Object stack() {
        return this.component().stack(this.stackSize());
    }

    public String description() {
        return this.component().description();
    }

    public Tooltip descriptionTooltip() {
        Tooltip.Builder builder = Tooltip.builder().addTextLine(this.description());
        this.stackSize().ifPresent(stackSize -> builder.setFormatting(TextFormatting.create(true, new EnumChatFormatting[0])).addTextLine(Lang.API.transf("stacksize", stackSize)));
        if (this.component().nbt().isPresent()) {
            NBTTagCompound nbt = this.component().nbt().get();
            if (NEIClientUtils.shiftKey()) {
                builder.addSpacing().setFormatting(Tooltip.TRIVIAL_FORMATTING).addAllTextLines(NBT_SPLITTER.split((CharSequence)nbt.toString()));
            } else {
                builder.addSpacing().setFormatting(Tooltip.INFO_FORMATTING).addTextLine(Lang.API.trans("hasnbt"));
            }
        }
        return builder.build();
    }

    public void interact(Interactable.RecipeType recipeType) {
        this.component().interact(recipeType);
    }

    public void draw(Point pos) {
        this.component().draw(pos);
        if (this.stackSize().isPresent()) {
            int stackSize = this.stackSize().get();
            switch (this.type()) {
                case ITEM: {
                    if (!ConfigOptions.SHOW_STACK_SIZE_ONE.get().booleanValue() && stackSize == 1) break;
                    Draw.drawStackSize(stackSize, pos);
                    break;
                }
                case FLUID: {
                    Draw.drawStackSize(stackSize, pos);
                }
            }
        }
        this.additionalInfo().ifPresent(additionalInfo -> Draw.drawAdditionalInfo(additionalInfo, pos, true));
    }

    @ToPrettyString
    public abstract String toPrettyString();

    @Override
    public int compareTo(DisplayComponent other) {
        if (other == null) {
            return 1;
        }
        return COMPARATOR.compare(this, other);
    }

    public static Builder builder(Component component) {
        return new $AutoValue_DisplayComponent.Builder().setComponent(component).setAdditionalTooltip(Tooltip.EMPTY_TOOLTIP);
    }

    public static Builder builder(ItemStack itemStack) {
        return new $AutoValue_DisplayComponent.Builder().setComponent(ItemComponent.create(itemStack)).setStackSize(itemStack.field_77994_a).setAdditionalTooltip(Tooltip.EMPTY_TOOLTIP);
    }

    public static Builder builderWithNbt(ItemStack itemStack) {
        return new $AutoValue_DisplayComponent.Builder().setComponent(ItemComponent.createWithNbt(itemStack)).setStackSize(itemStack.field_77994_a).setAdditionalTooltip(Tooltip.EMPTY_TOOLTIP);
    }

    public static Builder builder(FluidStack fluidStack) {
        return new $AutoValue_DisplayComponent.Builder().setComponent(FluidComponent.create(fluidStack)).setStackSize(fluidStack.amount).setAdditionalTooltip(Tooltip.EMPTY_TOOLTIP);
    }

    public static Builder builderWithNbt(FluidStack fluidStack) {
        return new $AutoValue_DisplayComponent.Builder().setComponent(FluidComponent.createWithNbt(fluidStack)).setStackSize(fluidStack.amount).setAdditionalTooltip(Tooltip.EMPTY_TOOLTIP);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setComponent(Component var1);

        public abstract Builder setStackSize(Optional<Integer> var1);

        public abstract Builder setStackSize(int var1);

        public abstract Builder setAdditionalInfo(Optional<String> var1);

        public abstract Builder setAdditionalInfo(@Nullable String var1);

        public abstract Builder setAdditionalTooltip(Tooltip var1);

        public Builder clearStackSize() {
            return this.setStackSize(Optional.empty());
        }

        public Builder clearAdditionalInfo() {
            return this.setAdditionalInfo(Optional.empty());
        }

        public abstract DisplayComponent build();
    }
}

