/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.util;

import codechicken.nei.NEIClientUtils;
import java.util.StringJoiner;

public class NEIMouseUtils {
    public static final int MOUSE_BTN_NONE = Integer.MIN_VALUE;
    public static final int MOUSE_BTN_LMB = 0;
    public static final int MOUSE_BTN_RMB = 1;
    public static final int MOUSE_BTN_MMB = 2;
    public static final int MOUSE_SCROLL = 0x8000000;
    public static final int MOUSE_DRAG = 0x4000000;

    private NEIMouseUtils() {
    }

    public static String getHashName(int mouseBind) {
        StringJoiner mouseText = new StringJoiner(" + ");
        if ((mouseBind & 0x8000000) != 0) {
            mouseText.add(NEIClientUtils.translate("mouse.scroll", new Object[0]));
        }
        if ((mouseBind & 0x4000000) != 0) {
            mouseText.add(NEIClientUtils.translate("mouse.drag", new Object[0]));
        }
        return mouseText.toString();
    }

    public static String getKeyName(int mouseBind) {
        StringJoiner mouseText = new StringJoiner(" + ");
        String hashText = NEIMouseUtils.getHashName(mouseBind < 0 ? mouseBind - Integer.MIN_VALUE : mouseBind);
        if (mouseBind >= 0) {
            int button = NEIMouseUtils.unhash(mouseBind);
            switch (button) {
                case 0: {
                    mouseText.add(NEIClientUtils.translate("mouse.left", new Object[0]));
                    break;
                }
                case 1: {
                    mouseText.add(NEIClientUtils.translate("mouse.right", new Object[0]));
                    break;
                }
                case 2: {
                    mouseText.add(NEIClientUtils.translate("mouse.middle", new Object[0]));
                    break;
                }
                default: {
                    mouseText.add(NEIClientUtils.translate("mouse.other", button));
                }
            }
        }
        if (!hashText.isEmpty()) {
            mouseText.add(hashText);
        }
        return mouseText.toString();
    }

    public static int unhash(int mouseBind) {
        return mouseBind & 0xF3FFFFFF;
    }
}

