/*
 * Decompiled with CFR 0.152.
 */
package com.dyonovan.tcnodetracker.integration.navigator;

import com.dyonovan.tcnodetracker.TCNodeTracker;
import com.dyonovan.tcnodetracker.integration.navigator.ThaumcraftNodeButtonManager;
import com.dyonovan.tcnodetracker.integration.navigator.ThaumcraftNodeLocation;
import com.dyonovan.tcnodetracker.integration.navigator.journeymap.JMThaumcraftNodeRenderer;
import com.dyonovan.tcnodetracker.integration.navigator.journeymap.JMThaumcraftNodeWaypointManager;
import com.dyonovan.tcnodetracker.integration.navigator.xaero.XaeroThaumcraftNodeRenderer;
import com.dyonovan.tcnodetracker.integration.navigator.xaero.XaeroThaumcraftNodeWaypointManager;
import com.dyonovan.tcnodetracker.lib.NodeList;
import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.waypoints.WaypointManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public class ThaumcraftNodeLayerManager
extends InteractableLayerManager {
    public static final ThaumcraftNodeLayerManager instance = new ThaumcraftNodeLayerManager();
    private int oldMinBlockX = 0;
    private int oldMinBlockZ = 0;
    private int oldMaxBlockX = 0;
    private int oldMaxBlockZ = 0;

    public ThaumcraftNodeLayerManager() {
        super((ButtonManager)ThaumcraftNodeButtonManager.instance);
    }

    protected boolean needsRegenerateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        if (minBlockX != this.oldMinBlockX || minBlockZ != this.oldMinBlockZ || maxBlockX != this.oldMaxBlockX || maxBlockZ != this.oldMaxBlockZ) {
            this.oldMinBlockX = minBlockX;
            this.oldMinBlockZ = minBlockZ;
            this.oldMaxBlockX = maxBlockX;
            this.oldMaxBlockZ = maxBlockZ;
            return true;
        }
        return false;
    }

    @Nullable
    protected LayerRenderer addLayerRenderer(InteractableLayerManager manager, SupportedMods mod) {
        Object object;
        switch (mod) {
            case JourneyMap: {
                object = new JMThaumcraftNodeRenderer(manager);
                break;
            }
            case XaeroWorldMap: {
                object = new XaeroThaumcraftNodeRenderer(manager);
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    @Nullable
    protected WaypointManager addWaypointManager(InteractableLayerManager manager, SupportedMods mod) {
        Object object;
        switch (mod) {
            case JourneyMap: {
                object = new JMThaumcraftNodeWaypointManager(manager);
                break;
            }
            case XaeroWorldMap: {
                object = new XaeroThaumcraftNodeWaypointManager(manager);
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    protected List<? extends IWaypointAndLocationProvider> generateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        int playerDimensionId = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        ArrayList<ThaumcraftNodeLocation> thaumcraftNodeLocations = new ArrayList<ThaumcraftNodeLocation>();
        for (NodeList node : TCNodeTracker.nodelist) {
            if (node.dim != playerDimensionId || node.x < minBlockX || node.x > maxBlockX || node.z < minBlockZ || node.z > maxBlockZ) continue;
            thaumcraftNodeLocations.add(new ThaumcraftNodeLocation(node));
        }
        return thaumcraftNodeLocations;
    }

    public void deleteNode(ThaumcraftNodeLocation thaumcraftNodeLocation) {
        TCNodeTracker.nodelist.removeIf(thaumcraftNodeLocation::belongsToNode);
        if (thaumcraftNodeLocation.isActiveAsWaypoint()) {
            this.clearActiveWaypoint();
        }
        this.forceRefresh();
    }
}

