/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls;

import com.creativemd.creativecore.common.gui.SubGui;
import com.creativemd.creativecore.common.gui.event.GuiControlEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiControl {
    public static final int White = 0xE0E0E0;
    public static Minecraft mc = Minecraft.func_71410_x();
    private int id = -1;
    public boolean isContainerControl = false;
    public int posX;
    public int posY;
    public int height;
    public int width;
    public int rotation;
    public boolean visible;
    public boolean enabled;
    public SubGui parent;
    public String name;

    public void resetID() {
        this.id = -1;
    }

    public void setID(int id) {
        if (this.id == -1) {
            this.id = id;
        }
    }

    public int getID() {
        return this.id;
    }

    public GuiControl(String name, int x, int y, int width, int height, int rotation) {
        this.name = name;
        this.posX = x;
        this.posY = y;
        this.width = width;
        this.height = height;
        this.rotation = rotation;
        this.enabled = true;
        this.visible = true;
    }

    public GuiControl(String name, int x, int y, int width, int height) {
        this(name, x, y, width, height, 0);
    }

    public GuiControl setRotation(int rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiControl setContainerControl() {
        this.isContainerControl = true;
        return this;
    }

    public void init() {
    }

    public abstract void drawControl(FontRenderer var1);

    public void renderControl(FontRenderer renderer, int zLevel) {
        Vector2d centerOffset = this.getCenterOffset();
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)this.posX + centerOffset.x), (double)((double)this.posY + centerOffset.y), (double)0.0);
        GL11.glRotated((double)this.rotation, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-centerOffset.x), (double)(-centerOffset.y), (double)0.0);
        this.drawControl(renderer);
        GL11.glPopMatrix();
    }

    public GuiControl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isInteractable() {
        return this.visible && this.enabled;
    }

    public boolean isMouseOver() {
        Vector2d mouse = this.parent.getMousePos();
        Vector2d pos = this.getValidPos((int)mouse.x, (int)mouse.y);
        return this.enabled && this.parent.isTopLayer() && this.visible && this.isMouseOver((int)pos.x, (int)pos.y);
    }

    public boolean isMouseOver(int posX, int posY) {
        return posX >= this.posX && posX < this.posX + this.width && posY >= this.posY && posY < this.posY + this.height;
    }

    public boolean mouseScrolled(int posX, int posY, int scrolled) {
        return false;
    }

    public boolean mousePressed(int posX, int posY, int button) {
        return false;
    }

    public boolean mouseDragged(int posX, int posY, int button, long time) {
        return false;
    }

    public void mouseReleased(int posX, int posY, int button) {
    }

    public void mouseMove(int posX, int posY, int button) {
    }

    public void moveControlAbove(GuiControl controlInBack) {
        this.parent.moveControlAbove(this, controlInBack);
    }

    public void moveControlBehind(GuiControl controlInFront) {
        this.parent.moveControlBehind(this, controlInFront);
    }

    public void moveControlToBottom() {
        this.parent.moveControlToBottom(this);
    }

    public void moveControlToTop() {
        this.parent.moveControlToTop(this);
    }

    public boolean is(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public void onLoseFocus() {
    }

    public boolean onKeyPressed(char character, int key) {
        return false;
    }

    public void onGuiClose() {
    }

    public ArrayList<String> getTooltip() {
        return new ArrayList<String>();
    }

    public boolean raiseEvent(GuiControlEvent event) {
        return this.parent.raiseEvent(event);
    }

    public Vector2d getCenterOffset() {
        return new Vector2d((double)(this.width / 2), (double)(this.height / 2));
    }

    public Vector2d getValidPos(int x, int y) {
        Vector2d pos = new Vector2d((double)x, (double)y);
        Vector2d centerOffset = this.getCenterOffset();
        return GuiControl.getRotationAround(-this.rotation, pos, new Vector2d((double)this.posX + centerOffset.x, (double)this.posY + centerOffset.y));
    }

    public static void playSound(String soundID) {
        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(soundID), (float)1.0f));
    }

    public static Vector2d getMousePos(int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        int x = Mouse.getEventX() * i / mc.field_71443_c;
        int y = j - Mouse.getEventY() * j / mc.field_71440_d - 1;
        int movex = (i - width) / 2;
        int movey = (j - height) / 2;
        return new Vector2d((double)(x -= movex), (double)(y -= movey));
    }

    public static Vector2d getRotationAround(double angle, Vector2d pos, Vector2d center) {
        Vector2d result = new Vector2d(pos);
        result.sub((Tuple2d)center);
        Vector2d temp = new Vector2d(result);
        result.x = Math.cos(Math.toRadians(angle)) * temp.x - Math.sin(Math.toRadians(angle)) * temp.y;
        result.y = Math.sin(Math.toRadians(angle)) * temp.x + Math.cos(Math.toRadians(angle)) * temp.y;
        result.add((Tuple2d)center);
        return result;
    }

    public static void renderControls(ArrayList<GuiControl> controls, FontRenderer renderer, int zLevel) {
        for (int i = 0; i < controls.size(); ++i) {
            controls.get(i).renderControl(renderer, zLevel);
        }
    }
}

