/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.multiblock;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TilePortalBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Portal
extends BlockDE
implements ITileEntityProvider {
    public Portal() {
        super(Material.field_151567_E);
        this.func_149722_s();
        this.func_149663_c("portal");
        ModBlocks.register(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(References.RESOURCESPREFIX + "transparency");
    }

    public int func_149645_b() {
        return References.idPortal;
    }

    public AxisAlignedBB func_149633_g(World worldIn, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TilePortalBlock();
    }

    public AxisAlignedBB func_149668_a(World worldIn, int x, int y, int z) {
        return null;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (world.field_72995_K) {
            return;
        }
        TileDislocatorReceptacle receptacle = this.getMaster(world, x, y, z);
        if (receptacle == null) {
            world.func_147468_f(x, y, z);
            return;
        }
        if (receptacle.isActive) {
            receptacle.validateActivePortal();
        }
        if (!receptacle.isActive && !receptacle.updating) {
            world.func_147468_f(x, y, z);
            return;
        }
        this.updateMetadata(world, x, y, z);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        TileDislocatorReceptacle receptacle = this.getMaster(world, x, y, z);
        if (receptacle == null) {
            world.func_147468_f(x, y, z);
            return;
        }
        if (receptacle.isActive && receptacle.getLocation() != null) {
            if (receptacle.coolDown > 0) {
                return;
            }
            receptacle.coolDown = 1;
            receptacle.getLocation().sendEntityToCoords(entity);
        } else {
            receptacle.validateActivePortal();
        }
    }

    private TileDislocatorReceptacle getMaster(World world, int x, int y, int z) {
        TileDislocatorReceptacle tileDislocatorReceptacle;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePortalBlock) {
            TilePortalBlock portal = (TilePortalBlock)tile;
            tileDislocatorReceptacle = portal.getMaster();
        } else {
            tileDislocatorReceptacle = null;
        }
        return tileDislocatorReceptacle;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return null;
    }

    private boolean isPortalOrFrame(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == ModBlocks.portal || block == ModBlocks.infusedObsidian || block == ModBlocks.dislocatorReceptacle;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.updateMetadata(world, x, y, z);
    }

    private void updateMetadata(World world, int x, int y, int z) {
        boolean hasPortalsAlongZAxis;
        if (world.field_72995_K || world.func_72805_g(x, y, z) != 0) {
            return;
        }
        int metadata = 0;
        boolean hasPortalsAlongXAxis = this.isPortalOrFrame((IBlockAccess)world, x + 1, y, z) && this.isPortalOrFrame((IBlockAccess)world, x - 1, y, z);
        boolean hasPortalsAlongYAxis = this.isPortalOrFrame((IBlockAccess)world, x, y + 1, z) && this.isPortalOrFrame((IBlockAccess)world, x, y - 1, z);
        boolean bl = hasPortalsAlongZAxis = this.isPortalOrFrame((IBlockAccess)world, x, y, z + 1) && this.isPortalOrFrame((IBlockAccess)world, x, y, z - 1);
        if (hasPortalsAlongXAxis && hasPortalsAlongYAxis) {
            metadata = 1;
        } else if (hasPortalsAlongYAxis && hasPortalsAlongZAxis) {
            metadata = 2;
        } else if (hasPortalsAlongXAxis && hasPortalsAlongZAxis) {
            metadata = 3;
        }
        world.func_72921_c(x, y, z, metadata, 2);
    }
}

