/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class RenderTileReactorCore
extends TileEntitySpecialRenderer {
    public static IModelCustom reactorModel;

    public RenderTileReactorCore() {
        reactorModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("DraconicEvolution".toLowerCase(), "models/reactorCoreModel.obj"));
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        TileReactorCore core = (TileReactorCore)tileEntity;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        this.renderReactorCore(core, partialTick);
        GL11.glPopMatrix();
    }

    public void renderReactorCore(TileReactorCore core, float partialTick) {
        float rotation = core.renderRotation * 0.2f + partialTick * (core.renderSpeed * 0.2f);
        double fieldChargePercentage = core.maxFieldCharge > 0.0 ? core.fieldCharge / core.maxFieldCharge : 0.0;
        double r = fieldChargePercentage < 0.5 ? 1.0 - fieldChargePercentage * 2.0 : 0.0;
        double g = fieldChargePercentage > 0.5 ? (fieldChargePercentage - 0.5) * 2.0 : 0.0;
        double b = fieldChargePercentage * 2.0;
        double a = fieldChargePercentage < 0.1 ? fieldChargePercentage * 10.0 : 1.0;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)200.0f, (float)200.0f);
        if (core.reactorFuel + core.convertedFuel < 144) {
            ResourceHandler.bindResource("textures/blocks/draconic_block_blank.png");
            GL11.glPushMatrix();
            GL11.glScaled((double)0.1, (double)0.1, (double)0.1);
            reactorModel.renderAll();
            GL11.glPopMatrix();
        }
        ResourceHandler.bindResource("textures/models/reactorCore.png");
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glRotatef((float)rotation, (float)0.5f, (float)1.0f, (float)0.5f);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        double diameter = core.getCoreDiameter();
        GL11.glScaled((double)diameter, (double)diameter, (double)diameter);
        reactorModel.renderAll();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        if (core.reactionTemperature < 2000.0) {
            ResourceHandler.bindResource("textures/blocks/draconic_block_blank.png");
            if (core.reactionTemperature > 1000.0) {
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)(1.0 - (core.reactionTemperature - 1000.0) / 1000.0));
            }
            reactorModel.renderAll();
        }
        ResourceHandler.bindResource("textures/models/reactorShieldPlate.png");
        GL11.glColor4d((double)r, (double)g, (double)b, (double)a);
        GL11.glScaled((double)1.03f, (double)1.03f, (double)1.03f);
        GL11.glRotatef((float)2343.0f, (float)0.5f, (float)1.0f, (float)0.5f);
        GL11.glRotatef((float)(-rotation * 2.0f), (float)0.5f, (float)1.0f, (float)0.5f);
        reactorModel.renderAll();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        GL11.glPopMatrix();
    }
}

