/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.componentguis;

import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentBase;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentButton;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentCollection;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentTextureButton;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentTexturedRect;
import com.brandon3055.brandonscore.client.gui.guicomponents.GUIBase;
import com.brandon3055.brandonscore.client.utills.GuiHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.common.container.ContainerReactor;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GUIReactor
extends GUIBase {
    private static boolean showStatistics = false;
    private final TileReactorCore core;
    private final ContainerReactor container;

    public GUIReactor(TileReactorCore core, ContainerReactor container) {
        super((Container)container, 248, 222);
        this.core = core;
        this.container = container;
    }

    protected ComponentCollection assembleComponents() {
        ResourceLocation widgets = ResourceHandler.getResource("textures/gui/Widgets.png");
        this.collection = new ComponentCollection(0, 0, 248, 222, (GUIBase)this);
        this.collection.addComponent((ComponentBase)new ComponentTexturedRect(0, 0, this.field_146999_f, this.field_147000_g, ResourceHandler.getResource("textures/gui/Reactor.png")));
        this.collection.addComponent((ComponentBase)new ComponentTextureButton(14, 190, 18, 162, 18, 18, 0, (GUIBase)this, "", StatCollector.func_74838_a((String)"button.de.reactorCharge.txt"), widgets)).setName("CHARGE");
        this.collection.addComponent((ComponentBase)new ComponentTextureButton(14, 190, 18, 54, 18, 18, 1, (GUIBase)this, "", StatCollector.func_74838_a((String)"button.de.reactorStart.txt"), widgets)).setName("ACTIVATE");
        this.collection.addComponent((ComponentBase)new ComponentTextureButton(216, 190, 18, 108, 18, 18, 2, (GUIBase)this, "", StatCollector.func_74838_a((String)"button.de.reactorStop.txt"), widgets)).setName("DEACTIVATE");
        this.collection.addComponent((ComponentBase)new ComponentButton(9, 120, 43, 15, 3, (GUIBase)this, StatCollector.func_74838_a((String)"button.de.stats.txt"), StatCollector.func_74838_a((String)"button.de.statsShow.txt"))).setName("STATS");
        return this.collection;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.core.reactorState == TileReactorCore.ReactorState.OFFLINE) {
            RenderHelper.func_74520_c();
            this.func_73729_b(this.field_147003_i + 14, this.field_147009_r + 139, 14, this.field_147000_g, 18, 18);
            this.func_73729_b(this.field_147003_i + 216, this.field_147009_r + 139, 32, this.field_147000_g, 18, 18);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.insert.txt"), this.field_147003_i + 8, this.field_147009_r + 159, 0);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.fuel.txt"), this.field_147003_i + 13, this.field_147009_r + 168, 0);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.extract.txt"), this.field_147003_i + 206, this.field_147009_r + 159, 0);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.fuel.txt"), this.field_147003_i + 215, this.field_147009_r + 168, 0);
        }
        this.func_73732_a(this.field_146289_q, "Draconic Reactor", this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 4, 65535);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        ResourceHandler.bindResource("textures/gui/Reactor.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double value = Math.min(this.core.reactionTemperature, this.core.maxReactTemperature) / this.core.maxReactTemperature;
        int pixOffset = (int)(value * 108.0);
        this.func_73729_b(11, 112 - pixOffset, 0, 222, 14, 5);
        value = this.core.fieldCharge / this.core.maxFieldCharge;
        pixOffset = (int)(value * 108.0);
        this.func_73729_b(35, 112 - pixOffset, 0, 222, 14, 5);
        value = (double)this.core.energySaturation / (double)this.core.maxEnergySaturation;
        pixOffset = (int)(value * 108.0);
        this.func_73729_b(199, 112 - pixOffset, 0, 222, 14, 5);
        value = (double)this.core.convertedFuel / ((double)this.core.reactorFuel + (double)this.core.convertedFuel);
        pixOffset = (int)(value * 108.0);
        this.func_73729_b(223, 112 - pixOffset, 0, 222, 14, 5);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (showStatistics) {
            ResourceHandler.bindResource("textures/gui/Reactor.png");
            for (int i = 1; i <= 10; ++i) {
                this.func_73729_b(63, i * 12, 0, 240, 122, 16);
            }
            this.drawStatistics();
        } else {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glTranslated((double)124.0, (double)71.0, (double)100.0);
            double scale = 100.0 / this.core.getCoreDiameter();
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2884);
            TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)this.core, -0.5, -0.5, -0.5, 0.0f);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            this.drawStatus();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ArrayList<String> text = new ArrayList<String>();
        if (GuiHelper.isInRect((int)9, (int)4, (int)18, (int)114, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.add(StatCollector.func_74838_a((String)"gui.de.reactionTemp.txt"));
            text.add((int)this.core.reactionTemperature + "C");
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)33, (int)4, (int)18, (int)114, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.add(StatCollector.func_74838_a((String)"gui.de.fieldStrength.txt"));
            if (this.core.maxFieldCharge > 0.0) {
                text.add(Utills.round((double)(this.core.fieldCharge / this.core.maxFieldCharge * 100.0), (double)100.0) + "%");
            }
            text.add(Utills.addCommas((int)((int)this.core.fieldCharge)) + " / " + Utills.addCommas((int)((int)this.core.maxFieldCharge)));
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)197, (int)4, (int)18, (int)114, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.add(StatCollector.func_74838_a((String)"gui.de.energySaturation.txt"));
            if (this.core.maxEnergySaturation > 0) {
                text.add(Utills.round((double)((double)this.core.energySaturation / (double)this.core.maxEnergySaturation * 100.0), (double)100.0) + "%");
            }
            text.add(Utills.addCommas((int)this.core.energySaturation) + " / " + Utills.addCommas((int)this.core.maxEnergySaturation));
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)221, (int)4, (int)18, (int)114, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.add(StatCollector.func_74838_a((String)"gui.de.fuelConversion.txt"));
            if (this.core.reactorFuel + this.core.convertedFuel > 0) {
                text.add(Utills.round((double)(((double)this.core.convertedFuel + this.core.conversionUnit) / ((double)this.core.convertedFuel + (double)this.core.reactorFuel) * 100.0), (double)100.0) + "%");
            }
            text.add(this.core.convertedFuel + " / " + (this.core.convertedFuel + this.core.reactorFuel));
            text.add("Full: " + Utills.round((double)((float)(this.core.convertedFuel + this.core.reactorFuel) / (float)ConfigHandler.reactorFuelStorage * 100.0f), (double)1000.0) + "%");
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        }
        if (showStatistics) {
            if (GuiHelper.isInRect((int)53, (int)15, (int)140, (int)18, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
                text.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)"gui.de.reacTempLoadFactor.txt"), 200));
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
            } else if (GuiHelper.isInRect((int)53, (int)40, (int)140, (int)18, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
                text.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)"gui.de.reacCoreMass.txt"), 200));
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
            } else if (GuiHelper.isInRect((int)53, (int)65, (int)140, (int)18, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
                text.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)"gui.de.reacGenRate.txt"), 200));
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
            } else if (GuiHelper.isInRect((int)53, (int)88, (int)140, (int)18, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
                text.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)"gui.de.reacInputRate.txt"), 200));
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
            } else if (GuiHelper.isInRect((int)53, (int)113, (int)140, (int)18, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
                text.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)"gui.de.reacConversionRate.txt"), 200));
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
            }
        }
    }

    private void drawStatistics() {
        double inputRate = (double)this.core.fieldDrain / (1.0 - this.core.fieldCharge / this.core.maxFieldCharge);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.tempLoad.name"), 55, 16, 255);
        this.field_146289_q.func_78276_b(Utills.round((double)(this.core.tempDrainFactor * 100.0), (double)1.0) + "%", 60, 26, 0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.mass.name"), 55, 40, 255);
        this.field_146289_q.func_78276_b(Utills.round((double)((double)(this.core.reactorFuel + this.core.convertedFuel) / 1296.0), (double)100.0) + "m^3", 60, 50, 0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.genRate.name"), 55, 64, 255);
        this.field_146289_q.func_78276_b(Utills.addCommas((int)((int)this.core.generationRate)) + "RF/t", 60, 74, 0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.fieldInputRate.name"), 55, 88, 255);
        this.field_146289_q.func_78276_b(Utills.addCommas((int)((int)Math.min(inputRate, 2.147483647E9))) + "RF/t", 60, 98, 0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.fuelConversion.name"), 55, 112, 255);
        this.field_146289_q.func_78276_b(Utills.addCommas((int)((int)Math.round(this.core.fuelUseRate * 1000000.0))) + "nb/t", 60, 122, 0);
    }

    private void drawStatus() {
        String status = StatCollector.func_74838_a((String)"gui.de.status.txt") + ": ";
        switch (this.core.reactorState) {
            case OFFLINE: {
                status = status + EnumChatFormatting.DARK_GRAY;
                break;
            }
            case STARTING: 
            case STOPPING: {
                status = status + EnumChatFormatting.RED;
                break;
            }
            case ONLINE: {
                status = status + EnumChatFormatting.DARK_GREEN;
                break;
            }
            case INVALID: {
                status = status + EnumChatFormatting.DARK_RED;
            }
        }
        status = status + this.core.reactorState.toLocalizedString(this.core.canStart());
        this.field_146289_q.func_78276_b(status, this.field_146999_f - 5 - this.field_146289_q.func_78256_a(status), 125, 0);
    }

    public void func_73876_c() {
        this.collection.getComponent("DEACTIVATE").setEnabled(this.core.reactorState == TileReactorCore.ReactorState.STARTING || this.core.reactorState == TileReactorCore.ReactorState.ONLINE);
        this.collection.getComponent("CHARGE").setEnabled((this.core.reactorState == TileReactorCore.ReactorState.OFFLINE || this.core.reactorState == TileReactorCore.ReactorState.STOPPING && !this.core.canStart()) && this.core.canCharge());
        this.collection.getComponent("ACTIVATE").setEnabled((this.core.reactorState == TileReactorCore.ReactorState.STARTING || this.core.reactorState == TileReactorCore.ReactorState.STOPPING) && this.core.canStart());
        super.func_73876_c();
    }

    public void buttonClicked(int id, int button) {
        super.buttonClicked(id, button);
        if (id < 3) {
            this.container.sendObjectToServer(null, 20, id);
        } else if (id == 3) {
            showStatistics = !showStatistics;
            ((ComponentButton)this.collection.getComponent((String)"STATS")).hoverText = showStatistics ? StatCollector.func_74838_a((String)"button.de.statsHide.txt") : StatCollector.func_74838_a((String)"button.de.statsShow.txt");
        }
    }
}

