/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.overlay;

import com.caedis.duradisplay.config.ConfigDurabilityLike;
import com.caedis.duradisplay.overlay.OverlayDurability;
import com.caedis.duradisplay.overlay.OverlayDurabilityLike;
import com.caedis.duradisplay.utils.ColorType;
import com.caedis.duradisplay.utils.DurabilityFormatter;
import com.caedis.duradisplay.utils.DurabilityLikeInfo;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.item.brew.ItemBrewBase;

public class OverlayPotionBrew
extends OverlayDurabilityLike {
    public OverlayPotionBrew() {
        super(new ConfigDurabilityLike(true, OverlayDurabilityLike.Style.Text, DurabilityFormatter.Format.remaining, 2, true, true, 0xFFFFFF, ColorType.Single, new double[]{30.0, 70.0}, new int[]{0xFF0000, 16760264, 0xFFFFFF}, true, 2, true){

            @Override
            public void postLoadConfig() {
                this.configCategory.setComment("PotionBrew is the module that shows the remaining swigs of potions and brews\ncurrently Botania brews and Blood Magic AlchemyFlask\n");
            }

            @Override
            @NotNull
            public String category() {
                return "potion_brew";
            }
        });
        this.addHandler("vazkii.botania.common.item.brew.ItemBrewBase", OverlayPotionBrew::handleBotaniaBrew);
        this.addHandler("WayofTime.alchemicalWizardry.common.items.potion.AlchemyFlask", OverlayDurability::handleDefault);
    }

    @Override
    @NotNull
    ConfigDurabilityLike config() {
        return this.config;
    }

    public static DurabilityLikeInfo handleBotaniaBrew(@NotNull ItemStack stack) {
        ItemBrewBase brew = (ItemBrewBase)stack.func_77973_b();
        assert (brew != null);
        double current = brew.getSwigsLeft(stack);
        double max = brew.func_77612_l();
        return new DurabilityLikeInfo(current, max);
    }
}

