/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class EntityShockOrdVisitor
extends ClassVisitor {
    public EntityShockOrdVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("onImpact".equals(name) || "func_70184_a".equals(name)) {
            TC4Transformer.log.debug("Visiting {}{}", new Object[]{name, desc});
            return new OnImpactVisitor(this.api, mv);
        }
        return mv;
    }

    private static class OnImpactVisitor
    extends MethodVisitor {
        private int state;

        public OnImpactVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (this.state == 0 && opcode == 184 && "canEntityBeSeen".equals(name)) {
                TC4Transformer.log.trace("Found first canEntityBeSeen");
                this.state = 1;
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (this.state == 1 && opcode == 153) {
                TC4Transformer.log.trace("Found IFEQ. Injecting canEarthShockHurt()");
                this.state = 2;
                this.mv.visitVarInsn(25, 4);
                this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhookServer", "canEarthShockHurt", "(Lnet/minecraft/entity/Entity;)Z", false);
                this.mv.visitJumpInsn(opcode, label);
            }
        }

        public void visitEnd() {
            if (this.state != 2) {
                TC4Transformer.log.warn("Unexpected end of bytecode. Current state: {}", new Object[]{this.state});
            }
            super.visitEnd();
        }
    }
}

