/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.common;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.machine.MachineHost;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.common.SaveHandler;
import li.cil.oc.common.SaveHandlerJava17Functionality$;
import li.cil.oc.util.BlockPosition;
import li.cil.oc.util.BlockPosition$;
import li.cil.oc.util.SafeThreadPool;
import li.cil.oc.util.ThreadPoolFactory$;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SaveHandler$ {
    public static final SaveHandler$ MODULE$;
    private final String li$cil$oc$common$SaveHandler$$uuidRegex;
    private final int li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves;
    private boolean savingForClients;
    private final SafeThreadPool stateSaveHandler;
    private final ConcurrentLinkedDeque<File> chunkDirs;
    private final HashMap<String, Future<?>> saving;

    static {
        new SaveHandler$();
    }

    public String li$cil$oc$common$SaveHandler$$uuidRegex() {
        return this.li$cil$oc$common$SaveHandler$$uuidRegex;
    }

    public int li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves() {
        return this.li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves;
    }

    public boolean savingForClients() {
        return this.savingForClients;
    }

    public void savingForClients_$eq(boolean x$1) {
        this.savingForClients = x$1;
    }

    public SafeThreadPool stateSaveHandler() {
        return this.stateSaveHandler;
    }

    public ConcurrentLinkedDeque<File> chunkDirs() {
        return this.chunkDirs;
    }

    public HashMap<String, Future<?>> saving() {
        return this.saving;
    }

    public File savePath() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), Settings$.MODULE$.savePath());
    }

    public File statePath() {
        return new File(this.savePath(), "state");
    }

    public void scheduleSave(MachineHost host, NBTTagCompound nbt, String name, byte[] data) {
        this.scheduleSave(BlockPosition$.MODULE$.apply(host), nbt, name, data);
    }

    public void scheduleSave(MachineHost host, NBTTagCompound nbt, String name, Function1<NBTTagCompound, BoxedUnit> save2) {
        this.scheduleSave(host, nbt, name, this.writeNBT(save2));
    }

    public void scheduleSave(EnvironmentHost host, NBTTagCompound nbt, String name, Function1<NBTTagCompound, BoxedUnit> save2) {
        this.scheduleSave(BlockPosition$.MODULE$.apply(host), nbt, name, this.writeNBT(save2));
    }

    public void scheduleSave(World world, double x, double z, NBTTagCompound nbt, String name, byte[] data) {
        this.scheduleSave(BlockPosition$.MODULE$.apply(x, 0.0, z, world), nbt, name, data);
    }

    public void scheduleSave(World world, double x, double z, NBTTagCompound nbt, String name, Function1<NBTTagCompound, BoxedUnit> save2) {
        this.scheduleSave(world, x, z, nbt, name, this.writeNBT(save2));
    }

    public void scheduleSave(BlockPosition position, NBTTagCompound nbt, String name, byte[] data) {
        World world = (World)position.world().get();
        if (world instanceof WorldServer) {
            int dimension = world.field_73011_w.field_76574_g;
            ChunkCoordIntPair chunk = new ChunkCoordIntPair(position.x() >> 4, position.z() >> 4);
            nbt.func_74768_a("dimension", dimension);
            nbt.func_74768_a("chunkX", chunk.field_77276_a);
            nbt.func_74768_a("chunkZ", chunk.field_77275_b);
            this.scheduleSave(dimension, chunk, name, data);
        }
    }

    private byte[] writeNBT(Function1<NBTTagCompound, BoxedUnit> save2) {
        NBTTagCompound tmpNbt = new NBTTagCompound();
        save2.apply((Object)tmpNbt);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        CompressedStreamTools.func_74800_a((NBTTagCompound)tmpNbt, (DataOutput)dos);
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NBTTagCompound loadNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound nBTTagCompound;
        byte[] data = this.load(nbt, name);
        if (data.length <= 0) {
            nBTTagCompound = new NBTTagCompound();
            return nBTTagCompound;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            nBTTagCompound = CompressedStreamTools.func_74794_a((DataInputStream)dis);
            return nBTTagCompound;
        }
        catch (Throwable throwable) {
            OpenComputers$.MODULE$.log().warn("There was an error trying to restore a block's state from external data. This indicates that data was somehow corrupted.", throwable);
            nBTTagCompound = new NBTTagCompound();
        }
        return nBTTagCompound;
    }

    public byte[] load(NBTTagCompound nbt, String name) {
        int dimension = nbt.func_74762_e("dimension");
        ChunkCoordIntPair chunk = new ChunkCoordIntPair(nbt.func_74762_e("chunkX"), nbt.func_74762_e("chunkZ"));
        this.saving().get((Object)name).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Future<?> f) {
                Object object;
                try {
                    object = f.get(120L, TimeUnit.SECONDS);
                }
                catch (CancellationException cancellationException) {
                    object = BoxedUnit.UNIT;
                }
                catch (TimeoutException timeoutException) {
                    OpenComputers$.MODULE$.log().warn("Waiting for state data to save took two minutes! Aborting.");
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
        });
        this.saving().remove((Object)name);
        return this.load(dimension, chunk, name);
    }

    public void scheduleSave(int dimension, ChunkCoordIntPair chunk, String name, byte[] data) {
        if (chunk == null) {
            throw new IllegalArgumentException("chunk is null");
        }
        this.stateSaveHandler().withPool((Function1<ScheduledExecutorService, Future<?>>)new Serializable(dimension, chunk, name, data){
            public static final long serialVersionUID = 0L;
            private final int dimension$1;
            private final ChunkCoordIntPair chunk$1;
            private final String name$1;
            private final byte[] data$1;

            public final Future<?> apply(ScheduledExecutorService x$1) {
                return x$1.submit(new SaveHandler.SaveDataEntry(this.data$1, this.chunk$1, this.name$1, this.dimension$1));
            }
            {
                this.dimension$1 = dimension$1;
                this.chunk$1 = chunk$1;
                this.name$1 = name$1;
                this.data$1 = data$1;
            }
        }, this.stateSaveHandler().withPool$default$2()).foreach((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final Option<Future<?>> apply(Future<?> x$2) {
                return SaveHandler$.MODULE$.saving().put((Object)this.name$1, x$2);
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] load(int dimension, ChunkCoordIntPair chunk, String name) {
        byte[] byArray;
        if (chunk == null) {
            throw new IllegalArgumentException("chunk is null");
        }
        File path = this.statePath();
        File dimPath = new File(path, ((Object)BoxesRunTime.boxToInteger((int)dimension)).toString());
        File chunkPath = new File(dimPath, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)chunk.field_77276_a), BoxesRunTime.boxToInteger((int)chunk.field_77275_b)})));
        File file = new File(chunkPath, name);
        if (!file.exists()) return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int read = 0;
            do {
                if ((read = bis.read(buffer)) <= 0) continue;
                bos.write(buffer, 0, read);
            } while (read >= 0);
            bis.close();
            byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            OpenComputers$.MODULE$.log().warn("Error loading auxiliary tile entity data.", (Throwable)iOException);
            byArray = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        }
        return byArray;
    }

    public void cleanSaveData() {
        File[] emptyDirs = this.savePath().listFiles(new FileFilter(){

            public boolean accept(File file) {
                String[] list2;
                return file.isDirectory() && file.getName().matches(SaveHandler$.MODULE$.li$cil$oc$common$SaveHandler$$uuidRegex()) && System.currentTimeMillis() - file.lastModified() > (long)SaveHandler$.MODULE$.li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves() && ((list2 = file.list()) == null || Predef$.MODULE$.refArrayOps((Object[])list2).isEmpty());
            }
        });
        if (emptyDirs != null) {
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])emptyDirs).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$3) {
                    return x$3 != null;
                }
            })).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$4) {
                    return x$4.delete();
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldLoad(WorldEvent.Load e) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7)) {
            SaveHandlerJava17Functionality$.MODULE$.visitJava17(this.statePath());
        } else {
            this.visitJava16();
        }
    }

    private void visitJava16() {
        this.li$cil$oc$common$SaveHandler$$recurse$1(this.statePath());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldSave(WorldEvent.Save e) {
        this.stateSaveHandler().withPool((Function1<ScheduledExecutorService, Future<?>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Future<?> apply(ScheduledExecutorService x$5) {
                return x$5.submit(new Runnable(this){

                    public void run() {
                        SaveHandler$.MODULE$.cleanSaveData();
                    }
                });
            }
        }, this.stateSaveHandler().withPool$default$2());
    }

    public final void li$cil$oc$common$SaveHandler$$recurse$1(File file) {
        file.setLastModified(System.currentTimeMillis());
        if (file.exists() && file.isDirectory() && file.list() != null) {
            Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(File file) {
                    SaveHandler$.MODULE$.li$cil$oc$common$SaveHandler$$recurse$1(file);
                }
            });
        }
    }

    private SaveHandler$() {
        MODULE$ = this;
        this.li$cil$oc$common$SaveHandler$$uuidRegex = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
        this.li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves = 60000;
        this.savingForClients = false;
        this.stateSaveHandler = ThreadPoolFactory$.MODULE$.createSafePool("SaveHandler", 1);
        this.chunkDirs = new ConcurrentLinkedDeque();
        this.saving = HashMap$.MODULE$.empty();
    }
}

