/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Helpers;

import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import vswe.stevescarts.Helpers.EnchantmentData;

public class EnchantmentInfo {
    private Enchantment enchantment;
    private int rank1Value;
    private ENCHANTMENT_TYPE type;
    public static ArrayList<EnchantmentInfo> enchants = new ArrayList();
    public static EnchantmentInfo fortune = new EnchantmentInfo(Enchantment.field_77346_s, ENCHANTMENT_TYPE.TOOL, 50000);
    public static EnchantmentInfo efficiency = new EnchantmentInfo(Enchantment.field_77349_p, ENCHANTMENT_TYPE.TOOL, 50000);
    public static EnchantmentInfo unbreaking = new EnchantmentInfo(Enchantment.field_77347_r, ENCHANTMENT_TYPE.TOOL, 64000);
    public static EnchantmentInfo power = new EnchantmentInfo(Enchantment.field_77345_t, ENCHANTMENT_TYPE.SHOOTER, 750);
    public static EnchantmentInfo punch = new EnchantmentInfo(Enchantment.field_77344_u, ENCHANTMENT_TYPE.SHOOTER, 1000);
    public static EnchantmentInfo flame = new EnchantmentInfo(Enchantment.field_77343_v, ENCHANTMENT_TYPE.SHOOTER, 1000);
    public static EnchantmentInfo infinity = new EnchantmentInfo(Enchantment.field_77342_w, ENCHANTMENT_TYPE.SHOOTER, 500);

    public EnchantmentInfo(Enchantment enchantment, ENCHANTMENT_TYPE type, int rank1Value) {
        this.enchantment = enchantment;
        this.rank1Value = rank1Value;
        this.type = type;
        enchants.add(this);
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public int getMaxValue() {
        int max = 0;
        for (int i = 0; i < this.getEnchantment().func_77325_b(); ++i) {
            max += this.getValue(i + 1);
        }
        return max;
    }

    public int getValue(int level) {
        return (int)Math.pow(2.0, level - 1) * this.rank1Value;
    }

    public static boolean isItemValid(ArrayList<ENCHANTMENT_TYPE> enabledTypes, ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151134_bR) {
            for (EnchantmentInfo info : enchants) {
                int level;
                boolean isValid = false;
                for (ENCHANTMENT_TYPE type : enabledTypes) {
                    if (info.type != type) continue;
                    isValid = true;
                }
                if (!isValid || (level = EnchantmentInfo.getEnchantmentLevel(info.getEnchantment().field_77352_x, itemstack)) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static EnchantmentData addBook(ArrayList<ENCHANTMENT_TYPE> enabledTypes, EnchantmentData data, ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151134_bR) {
            if (data == null) {
                for (EnchantmentInfo info : enchants) {
                    data = EnchantmentInfo.addEnchantment(enabledTypes, data, itemstack, info);
                }
            } else {
                EnchantmentInfo.addEnchantment(enabledTypes, data, itemstack, data.getEnchantment());
            }
        }
        return data;
    }

    private static EnchantmentData addEnchantment(ArrayList<ENCHANTMENT_TYPE> enabledTypes, EnchantmentData data, ItemStack itemstack, EnchantmentInfo info) {
        int level;
        boolean isValid = false;
        for (ENCHANTMENT_TYPE type : enabledTypes) {
            if (info.type != type) continue;
            isValid = true;
        }
        if (isValid && (level = EnchantmentInfo.getEnchantmentLevel(info.getEnchantment().field_77352_x, itemstack)) > 0) {
            int newValue;
            if (data == null) {
                data = new EnchantmentData(info);
            }
            if ((newValue = data.getEnchantment().getValue(level) + data.getValue()) <= data.getEnchantment().getMaxValue()) {
                data.setValue(newValue);
                --itemstack.field_77994_a;
            }
        }
        return data;
    }

    private static int getEnchantmentLevel(int par0, ItemStack par1ItemStack) {
        if (par1ItemStack == null) {
            return 0;
        }
        NBTTagList nbttaglist = Items.field_151134_bR.func_92110_g(par1ItemStack);
        if (nbttaglist == null) {
            return 0;
        }
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            short short1 = nbttaglist.func_150305_b(j).func_74765_d("id");
            short short2 = nbttaglist.func_150305_b(j).func_74765_d("lvl");
            if (short1 != par0) continue;
            return short2;
        }
        return 0;
    }

    public static EnchantmentData createDataFromEffectId(EnchantmentData data, short id) {
        for (EnchantmentInfo info : enchants) {
            if (info.getEnchantment().field_77352_x != id) continue;
            if (data == null) {
                data = new EnchantmentData(info);
                break;
            }
            data.setEnchantment(info);
            break;
        }
        return data;
    }

    public ENCHANTMENT_TYPE getType() {
        return this.type;
    }

    public static enum ENCHANTMENT_TYPE {
        TOOL,
        SHOOTER;

    }
}

