/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.update;

import chylex.hee.system.logging.Log;
import chylex.hee.system.util.DragonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Calendar;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

final class VersionEntry
implements Comparable<VersionEntry> {
    public final String versionIdentifier;
    public final String modVersionName;
    public final String modVersion;
    public final String[] mcVersions;
    public final String releaseDate;
    public final int buildId;
    private final byte orderId;

    VersionEntry(String versionIdentifier, JsonObject node) {
        this.versionIdentifier = versionIdentifier;
        this.modVersion = node.get("modVersion").getAsString();
        JsonArray array = node.get("mcVersions").getAsJsonArray();
        this.mcVersions = new String[array.size()];
        int a = -1;
        for (JsonElement mcVersionNode : array) {
            this.mcVersions[++a] = mcVersionNode.getAsString();
        }
        this.buildId = node.has("buildId") ? node.get("buildId").getAsInt() : 0;
        this.releaseDate = node.get("releaseDate").getAsString();
        byte i = 0;
        String tmp = this.modVersion;
        String[] idSplit = versionIdentifier.split(" - ");
        if (idSplit.length != 2) {
            Log.error("Incorrect version identifier: $0", versionIdentifier);
        } else {
            tmp = idSplit[1];
            try {
                i = Byte.parseByte(idSplit[0]);
            }
            catch (NumberFormatException e) {
                Log.error("Incorrect version identifier: $0", versionIdentifier);
            }
        }
        this.orderId = i;
        this.modVersionName = tmp;
    }

    public boolean isSupportedByMC(String mcVersion) {
        return ArrayUtils.contains((Object[])this.mcVersions, (Object)mcVersion);
    }

    public Calendar convertReleaseDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        String[] info = StringUtils.split((String)this.releaseDate, (char)' ');
        if (info.length != 3) {
            return cal;
        }
        int day = DragonUtil.tryParse(info[0], cal.get(5));
        int month = ArrayUtils.indexOf((Object[])new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}, (Object)info[1]);
        int year = DragonUtil.tryParse(info[2], cal.get(1));
        cal.set(year, month == -1 ? cal.get(2) : month, day);
        return cal;
    }

    @Override
    public int compareTo(VersionEntry o) {
        return o.orderId - this.orderId;
    }

    public int hashCode() {
        return this.orderId;
    }

    public boolean equals(Object obj) {
        return obj instanceof VersionEntry && ((VersionEntry)obj).orderId == this.orderId;
    }
}

