/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.misc;

import chylex.hee.mechanics.misc.PlayerDataHandler;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.MathUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerTransportBeacons
implements IExtendedEntityProperties {
    private static final String playerPropertyIdentifier = "HardcoreEnderExpansion~TransportBeacons";
    private Set<LocationXZ> locations = new HashSet<LocationXZ>();

    public static void register() {
        PlayerDataHandler.registerProperty(playerPropertyIdentifier, new PlayerDataHandler.IExtendedPropertyInitializer<PlayerTransportBeacons>(){

            @Override
            public PlayerTransportBeacons createNew(Entity entity) {
                return new PlayerTransportBeacons();
            }
        });
    }

    public static PlayerTransportBeacons getInstance(EntityPlayer player) {
        return (PlayerTransportBeacons)player.getExtendedProperties(playerPropertyIdentifier);
    }

    public boolean addBeacon(int x, int z) {
        return this.locations.add(new LocationXZ(x, z));
    }

    public boolean removeBeacon(int x, int z) {
        return this.locations.remove(new LocationXZ(x, z));
    }

    public boolean checkBeacon(int x, int z, int fromX, int fromZ) {
        return this.locations.contains(new LocationXZ(x, z)) && MathUtil.distance(fromX - x, fromZ - z) <= 960.0;
    }

    public Set<LocationXZ> getOffsets(int x, int z) {
        LocationXZ center = new LocationXZ(x, z);
        HashSet<LocationXZ> near = new HashSet<LocationXZ>();
        for (LocationXZ loc : this.locations) {
            if (!(loc.distance(center) <= 960.0)) continue;
            near.add(new LocationXZ(loc.x - x, loc.z - z));
        }
        return near;
    }

    public void init(Entity entity, World world) {
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (LocationXZ loc : this.locations) {
            list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{loc.x, loc.z}));
        }
        nbt.func_74782_a("HEE_TB_locs", (NBTBase)list);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        this.locations.clear();
        NBTTagList list = nbt.func_150295_c("HEE_TB_locs", 11);
        for (int a = 0; a < list.func_74745_c(); ++a) {
            int[] loc = list.func_150306_c(a);
            if (loc.length == 2) {
                this.locations.add(new LocationXZ(loc[0], loc[1]));
                continue;
            }
            Log.error("Corrupted data found when loading transport beacon, expected an int array of size 2, got $0", loc.length);
        }
    }

    public static final class LocationXZ {
        public final int x;
        public final int z;

        public LocationXZ(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public double distance(LocationXZ loc) {
            return MathUtil.distance(loc.x - this.x, loc.z - this.z);
        }

        public boolean equals(Object obj) {
            if (obj != null && obj.getClass() == LocationXZ.class) {
                LocationXZ loc = (LocationXZ)obj;
                return loc.x == this.x && loc.z == this.z;
            }
            return false;
        }

        public int hashCode() {
            return this.x * 6666689 + this.z;
        }
    }
}

