/*
 * Decompiled with CFR 0.152.
 */
package journeymap.shadow.io.javalin.core.compression;

import com.nixxcode.jvmbrotli.common.BrotliLoader;
import java.util.List;
import journeymap.shadow.io.javalin.core.compression.Brotli;
import journeymap.shadow.io.javalin.core.compression.Gzip;
import journeymap.shadow.io.javalin.core.util.JavalinLogger;
import journeymap.shadow.io.javalin.core.util.OptionalDependency;
import journeymap.shadow.io.javalin.core.util.Util;
import journeymap.shadow.kotlin.Metadata;
import journeymap.shadow.kotlin.collections.CollectionsKt;
import journeymap.shadow.kotlin.jvm.JvmField;
import journeymap.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import journeymap.shadow.kotlin.jvm.internal.Intrinsics;
import journeymap.shadow.org.jetbrains.annotations.NotNull;
import journeymap.shadow.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Ljourneymap/shadow/io/javalin/core/compression/CompressionStrategy;", "", "brotli", "Ljourneymap/shadow/io/javalin/core/compression/Brotli;", "gzip", "Ljourneymap/shadow/io/javalin/core/compression/Gzip;", "(Lio/javalin/core/compression/Brotli;Lio/javalin/core/compression/Gzip;)V", "getBrotli", "()Lio/javalin/core/compression/Brotli;", "excludedMimeTypesFromCompression", "", "", "getExcludedMimeTypesFromCompression", "()Ljava/util/List;", "setExcludedMimeTypesFromCompression", "(Ljava/util/List;)V", "getGzip", "()Lio/javalin/core/compression/Gzip;", "minSizeForCompression", "", "getMinSizeForCompression", "()I", "setMinSizeForCompression", "(I)V", "tryLoadBrotli", "Companion", "javalin"})
public final class CompressionStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Brotli brotli;
    @Nullable
    private final Gzip gzip;
    private int minSizeForCompression;
    @NotNull
    private List<String> excludedMimeTypesFromCompression;
    @JvmField
    @NotNull
    public static final CompressionStrategy NONE = new CompressionStrategy(null, null, 3, null);
    @JvmField
    @NotNull
    public static final CompressionStrategy GZIP = new CompressionStrategy(null, new Gzip(0, 1, null));

    public CompressionStrategy(@Nullable Brotli brotli, @Nullable Gzip gzip) {
        this.brotli = brotli != null ? this.tryLoadBrotli(brotli) : null;
        this.gzip = gzip;
        this.minSizeForCompression = 1500;
        String[] stringArray = new String[]{"image/", "audio/", "video/", "application/compress", "application/zip", "application/gzip", "application/bzip2", "application/brotli", "application/x-xz", "application/x-rar-compressed"};
        this.excludedMimeTypesFromCompression = CollectionsKt.listOf(stringArray);
    }

    public /* synthetic */ CompressionStrategy(Brotli brotli, Gzip gzip, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            brotli = null;
        }
        if ((n & 2) != 0) {
            gzip = null;
        }
        this(brotli, gzip);
    }

    @Nullable
    public final Brotli getBrotli() {
        return this.brotli;
    }

    @Nullable
    public final Gzip getGzip() {
        return this.gzip;
    }

    public final int getMinSizeForCompression() {
        return this.minSizeForCompression;
    }

    public final void setMinSizeForCompression(int n) {
        this.minSizeForCompression = n;
    }

    @NotNull
    public final List<String> getExcludedMimeTypesFromCompression() {
        return this.excludedMimeTypesFromCompression;
    }

    public final void setExcludedMimeTypesFromCompression(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.excludedMimeTypesFromCompression = list;
    }

    private final Brotli tryLoadBrotli(Brotli brotli) {
        Brotli brotli2;
        Util.INSTANCE.ensureDependencyPresent(OptionalDependency.JVMBROTLI, true);
        if (BrotliLoader.isBrotliAvailable()) {
            brotli2 = brotli;
        } else {
            JavalinLogger.warn$default("\nFailed to enable Brotli compression, because the jvm-brotli native library couldn't be loaded.\njvm-brotli is currently only supported on Windows, Linux and Mac OSX.\nIf you are running Javalin on a supported system, but are still getting this error,\ntry re-importing your Maven and/or Gradle dependencies. If that doesn't resolve it,\nplease create an issue at https://github.com/tipsy/javalin/\n---------------------------------------------------------------\nIf you still want compression, please ensure GZIP is enabled!\n---------------------------------------------------------------", null, 2, null);
            brotli2 = null;
        }
        return brotli2;
    }

    public CompressionStrategy() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljourneymap/shadow/io/javalin/core/compression/CompressionStrategy$Companion;", "", "()V", "GZIP", "Ljourneymap/shadow/io/javalin/core/compression/CompressionStrategy;", "NONE", "javalin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

