/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class JMThreadFactory
implements ThreadFactory {
    static final AtomicInteger threadNumber = new AtomicInteger(1);
    static final String namePrefix = "JM-";
    final ThreadGroup group;
    final String name;

    public JMThreadFactory(String name) {
        this.name = namePrefix + name;
        SecurityManager securitymanager = System.getSecurityManager();
        this.group = securitymanager == null ? Thread.currentThread().getThreadGroup() : securitymanager.getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String fullName = this.name + "-" + threadNumber.getAndIncrement();
        Thread thread2 = new Thread(this.group, runnable, fullName);
        if (thread2.isDaemon()) {
            thread2.setDaemon(false);
        }
        if (thread2.getPriority() != 5) {
            thread2.setPriority(5);
        }
        return thread2;
    }
}

