/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.io.nettyopis.handler.codec.http;

import mcp.mobius.shadow.io.nettyopis.buffer.ByteBuf;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelHandlerContext;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.DefaultHttpContent;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.HttpContent;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.LastHttpContent;
import mcp.mobius.shadow.io.nettyopis.handler.stream.ChunkedInput;

public class HttpChunkedInput
implements ChunkedInput<HttpContent> {
    private final ChunkedInput<ByteBuf> input;
    private final LastHttpContent lastHttpContent;
    private boolean sentLastChunk;

    public HttpChunkedInput(ChunkedInput<ByteBuf> input) {
        this.input = input;
        this.lastHttpContent = LastHttpContent.EMPTY_LAST_CONTENT;
    }

    public HttpChunkedInput(ChunkedInput<ByteBuf> input, LastHttpContent lastHttpContent) {
        this.input = input;
        this.lastHttpContent = lastHttpContent;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        if (this.input.isEndOfInput()) {
            return this.sentLastChunk;
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        this.input.close();
    }

    @Override
    public HttpContent readChunk(ChannelHandlerContext ctx) throws Exception {
        if (this.input.isEndOfInput()) {
            if (this.sentLastChunk) {
                return null;
            }
            this.sentLastChunk = true;
            return this.lastHttpContent;
        }
        ByteBuf buf = this.input.readChunk(ctx);
        return new DefaultHttpContent(buf);
    }
}

